/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.log.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.log.dto.SysLogOperationDTO;
import io.huimu.modules.log.excel.SysLogExceptionExcel;
import io.huimu.modules.log.param.LogExceptionPagParam;
import io.huimu.modules.log.service.SysLogExceptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"log/exception"})
@Api(tags={"\u5f02\u5e38\u65e5\u5fd7"})
public class SysLogExceptionController {
    @Autowired
    private SysLogExceptionService exceptionService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=LogExceptionPagParam.class)
    public Result<PageData<SysLogOperationDTO>> page(@RequestBody EncryptedReq<LogExceptionPagParam> req) throws IllegalAccessException {
        LogExceptionPagParam params = (LogExceptionPagParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.exceptionService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @GetMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="creatorName", value="\u64cd\u4f5c\u4eba\u5458", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65e5\u671f", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="requestUri", value="\u8bf7\u6c42URI", paramType="query", dataTypeClass=String.class)})
    public void export(@ApiIgnore @RequestParam Map<String, Object> params, HttpServletResponse response) throws Exception {
        List list = this.exceptionService.list(params);
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u5f02\u5e38\u65e5\u5fd7", (List)list, SysLogExceptionExcel.class);
    }
}

