/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.littlecheck.dto.SysExamKeyConfDTO;
import io.huimu.modules.littlecheck.entity.SysExamKeyConfEntity;
import io.huimu.modules.littlecheck.param.ExamKeyConfListParam;
import io.huimu.modules.littlecheck.param.ExamKeyConfPagParam;
import io.huimu.modules.littlecheck.service.SysExamKeyConfService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/key/conf"})
@Api(tags={"\u5e38\u89c4\u68c0\u67e5-\u952e\u76d8\u914d\u7f6e\u7ba1\u7406"})
public class SysExamKeyConfController {
    @Autowired
    private SysExamKeyConfService sysExamKeyConfService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="confType", value="\u914d\u7f6e\u7c7b\u578b\uff0c1\uff1a\u89c6\u529b\uff0c2\uff1a\u773c\u538b\uff0c3\uff1a\u9a8c\u5149", paramType="query", dataTypeClass=Integer.class), @ApiImplicitParam(name="confKey", value="\u914d\u7f6e\u9879", paramType="query", dataTypeClass=String.class)})
    @DecryptAndVerify(decryptedClass=ExamKeyConfPagParam.class)
    public Result<PageData<SysExamKeyConfDTO>> page(@RequestBody EncryptedReq<ExamKeyConfPagParam> req) throws IllegalAccessException {
        ExamKeyConfPagParam params = (ExamKeyConfPagParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.sysExamKeyConfService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ExamKeyConfListParam.class)
    public Result<List<SysExamKeyConfDTO>> getList(@RequestBody EncryptedReq<ExamKeyConfListParam> req) {
        ExamKeyConfListParam param = (ExamKeyConfListParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List list = this.sysExamKeyConfService.getList(param.getConfType(), param.getKeyType(), param.getFzFlag(), param.getConfKey());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879")
    @LogOperation(value="\u65b0\u589e\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879", module="\u5e38\u89c4\u68c0\u67e5\u952e\u76d8\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysExamKeyConfDTO.class)
    public Result save(@RequestBody EncryptedReq<SysExamKeyConfDTO> req) {
        SysExamKeyConfDTO dto = (SysExamKeyConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.sysExamKeyConfService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879")
    @LogOperation(value="\u4fee\u6539\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879", module="\u5e38\u89c4\u68c0\u67e5\u952e\u76d8\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=SysExamKeyConfDTO.class)
    public Result update(@RequestBody EncryptedReq<SysExamKeyConfDTO> req) {
        SysExamKeyConfDTO dto = (SysExamKeyConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.sysExamKeyConfService.updateById(ConvertUtils.sourceToTarget((Object)dto, SysExamKeyConfEntity.class));
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879")
    @LogOperation(value="\u5220\u9664\u5c0f\u68c0\u67e5\u952e\u76d8\u914d\u7f6e\u9879", module="\u5e38\u89c4\u68c0\u67e5\u952e\u76d8\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sysExamKeyConfService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }
}

