/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.littlecheck.dto.SysExamDeviceConfDTO;
import io.huimu.modules.littlecheck.param.ExamDeviceParam;
import io.huimu.modules.littlecheck.param.GetDevicePageParam;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/device/conf"})
@Api(tags={"\u5e38\u89c4\u68c0\u67e5-\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e\u7ba1\u7406"})
public class SysExamDeviceConfController {
    @Autowired
    private SysExamDeviceConfService sysExamDeviceConfService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u68c0\u67e5\u8bbe\u5907\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetDevicePageParam.class)
    public Result<PageData<SysExamDeviceConfDTO>> page(@RequestBody EncryptedReq<GetDevicePageParam> req) throws IllegalAccessException {
        GetDevicePageParam dto = (GetDevicePageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        PageData page = this.sysExamDeviceConfService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e")
    @LogOperation(value="\u4fdd\u5b58\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e", module="\u5e38\u89c4\u68c0\u67e5", operationType=1)
    @DecryptAndVerify(decryptedClass=SysExamDeviceConfDTO.class)
    public Result save(@RequestBody EncryptedReq<SysExamDeviceConfDTO> req) {
        SysExamDeviceConfDTO dto = (SysExamDeviceConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysExamDeviceConfService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e")
    @LogOperation(value="\u4fee\u6539\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e", module="\u5e38\u89c4\u68c0\u67e5", operationType=2)
    @DecryptAndVerify(decryptedClass=SysExamDeviceConfDTO.class)
    public Result update(@RequestBody EncryptedReq<SysExamDeviceConfDTO> req) {
        SysExamDeviceConfDTO dto = (SysExamDeviceConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysExamDeviceConfService.update(dto);
        return new Result();
    }

    @PostMapping(value={"changeAttribute"})
    @ApiOperation(value="\u8bbe\u5907\u8f6c\u6b63")
    @LogOperation(value="\u4fee\u6539\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e", module="\u5e38\u89c4\u68c0\u67e5", operationType=2)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result changeAttribute(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysExamDeviceConfService.changeAttribute(dto.getId());
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e")
    @LogOperation(value="\u5220\u9664\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e", module="\u5e38\u89c4\u68c0\u67e5", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sysExamDeviceConfService.delete(dto.getId());
        return new Result();
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u8bbe\u5907\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ExamDeviceParam.class)
    public Result getList(@RequestBody EncryptedReq<ExamDeviceParam> req) {
        ExamDeviceParam dto = (ExamDeviceParam)req.getData();
        AssertUtils.isBlank((String)dto.getOrgCode(), (String[])new String[]{"\u673a\u6784"});
        List list = this.sysExamDeviceConfService.getList(dto.getOrgCode(), dto.getExamTypeFlag(), dto.getCheckType());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getConfInfo"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u8bbe\u5907\u914d\u7f6e")
    @DecryptAndVerify(decryptedClass=ExamDeviceParam.class)
    public Result getConfInfo(@RequestBody EncryptedReq<ExamDeviceParam> req) {
        ExamDeviceParam dto = (ExamDeviceParam)req.getData();
        AssertUtils.isBlank((String)dto.getIdKey(), (String[])new String[]{"\u8bbe\u5907id"});
        SysExamDeviceConfDTO deviceConfDTO = this.sysExamDeviceConfService.getConfInfo(dto.getIdKey());
        return new Result().ok(req.getEncode(), (Object)deviceConfDTO);
    }
}

