/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.littlecheck.dto.DeviceParamDTO;
import io.huimu.modules.littlecheck.param.DeviceParamParam;
import io.huimu.modules.littlecheck.service.DeviceParamService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/device/param"})
@Api(tags={"\u5e38\u89c4\u68c0\u67e5-\u8bbe\u5907\u53c2\u6570\u7ba1\u7406"})
public class DeviceParamController {
    @Autowired
    private DeviceParamService deviceParamService;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58\u8bbe\u5907\u53c2\u6570")
    @DecryptAndVerify(decryptedClass=DeviceParamDTO.class)
    @LogOperation(value="\u4fdd\u5b58\u8bbe\u5907\u53c2\u6570", module="\u8bbe\u5907\u53c2\u6570", operationType=1)
    public Result save(@RequestBody EncryptedReq<DeviceParamDTO> req) {
        DeviceParamDTO dto = (DeviceParamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.deviceParamService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u8bbe\u5907\u53c2\u6570")
    @DecryptAndVerify(decryptedClass=DeviceParamDTO.class)
    @LogOperation(value="\u4fee\u6539\u8bbe\u5907\u53c2\u6570", module="\u8bbe\u5907\u53c2\u6570", operationType=2)
    public Result update(@RequestBody EncryptedReq<DeviceParamDTO> req) {
        DeviceParamDTO dto = (DeviceParamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class, UpdateGroup.class});
        this.deviceParamService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u53c2\u6570\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=DeviceParamParam.class)
    public Result getInfo(@RequestBody EncryptedReq<DeviceParamParam> req) {
        DeviceParamParam dto = (DeviceParamParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isBlank((String)dto.getId(), (String[])new String[]{"id"});
        DeviceParamDTO data = this.deviceParamService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"updateOpen"})
    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @LogOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001", module="\u8bbe\u5907\u53c2\u6570", operationType=2)
    @DecryptAndVerify(decryptedClass=DeviceParamParam.class)
    public Result updateOpen(@RequestBody EncryptedReq<DeviceParamParam> req) {
        DeviceParamParam dto = (DeviceParamParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isBlank((String)dto.getId(), (String[])new String[]{"id"});
        AssertUtils.isNull((Object)dto.getIsOpen(), (String[])new String[]{"\u72b6\u6001"});
        this.deviceParamService.updateOpen(dto.getId(), dto.getIsOpen());
        return new Result();
    }

    @PostMapping(value={"getListByPid"})
    @ApiOperation(value="\u6839\u636e\u7236\u7ea7id\uff0c\u83b7\u53d6\u8bbe\u5907\u53c2\u6570\u5217\u8868\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=DeviceParamParam.class)
    public Result getListByPid(@RequestBody EncryptedReq<DeviceParamParam> req) {
        DeviceParamParam dto = (DeviceParamParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isBlank((String)dto.getPid(), (String[])new String[]{"\u7236\u7ea7ID"});
        List list = this.deviceParamService.getListByPid(dto.getPid(), dto.getIsOpen(), dto.getCategory());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getChildrenList"})
    @ApiOperation(value="\u6839\u636e\u6811\u5f62\u7ed3\u6784")
    @DecryptAndVerify(decryptedClass=DeviceParamParam.class)
    public Result getChildrenList(@RequestBody EncryptedReq<DeviceParamParam> req) {
        DeviceParamParam dto = (DeviceParamParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.deviceParamService.getChildrenList(dto.getIsOpen(), dto.getCategory());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=DeviceParamParam.class)
    @LogOperation(value="\u5220\u9664\u8bbe\u5907\u53c2\u6570", module="\u8bbe\u5907\u53c2\u6570", operationType=3)
    public Result delete(@RequestBody EncryptedReq<DeviceParamParam> req) {
        DeviceParamParam dto = (DeviceParamParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isArrayEmpty((Object[])dto.getIds(), (String[])new String[]{"ids"});
        this.deviceParamService.delete(dto.getIds());
        return new Result();
    }
}

