/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.littlecheck.dto.DeviceFileDTO;
import io.huimu.modules.littlecheck.entity.DeviceFileEntity;
import io.huimu.modules.littlecheck.param.GetDeviceDataPageParam;
import io.huimu.modules.littlecheck.service.DeviceFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/device/file"})
@Api(tags={"\u5e38\u89c4\u68c0\u67e5-\u8bbe\u5907\u6570\u636e\u6587\u4ef6\u7ba1\u7406"})
public class DeviceFileController {
    @Autowired
    private DeviceFileService deviceFileService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetDeviceDataPageParam.class)
    public Result<PageData<DeviceFileEntity>> page(@RequestBody EncryptedReq<GetDeviceDataPageParam> req) throws IllegalAccessException {
        GetDeviceDataPageParam dto = (GetDeviceDataPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.deviceFileService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58\u8bbe\u5907\u539f\u59cb\u68c0\u67e5\u6570\u636e")
    @DecryptAndVerify(decryptedClass=DeviceFileDTO.class)
    @LogOperation(value="\u4fdd\u5b58\u8bbe\u5907\u539f\u59cb\u68c0\u67e5\u6570\u636e", module="\u8bbe\u5907\u539f\u59cb\u6570\u636e\u7ba1\u7406", operationType=1)
    public Result save(@RequestBody EncryptedReq<DeviceFileDTO> req) throws IOException {
        DeviceFileDTO dto = (DeviceFileDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.deviceFileService.save(dto);
        return new Result();
    }
}

