/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.jsversion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.modules.jsversion.dao.DataExtractJsDao;
import io.huimu.modules.jsversion.dto.DataExtractJsVersionDTO;
import io.huimu.modules.jsversion.entity.DataExtractJsEntity;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.huimu.modules.jsversion.service.DataExtractJsService;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataExtractJsServiceImpl
extends BaseServiceImpl<DataExtractJsDao, DataExtractJsEntity>
implements DataExtractJsService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public PageData<DataExtractJsVersionDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"fileName", "jsVersion"});
        String jsVersion = (String)params.get("jsVersion");
        String fileName = (String)params.get("fileName");
        IPage page = ((DataExtractJsDao)this.baseDao).selectPage(this.getPage(params, "create_date", true), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((CharSequence)jsVersion), (Object)"JS_VERSION", (Object)jsVersion)).like(StringUtils.isNotBlank((CharSequence)fileName), (Object)"FILE_NAME", (Object)fileName)).orderByDesc((Object)"JS_VERSION"));
        return this.getPageData(page, DataExtractJsVersionDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void pushVersion(DataExtractJsVersionDTO dto) throws IOException {
        DataExtractJsEntity entity = new DataExtractJsEntity();
        if (dto.getIsOpen() == 1) {
            entity = new DataExtractJsEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DataExtractJsEntity();
        entity.setFileName(dto.getFileName());
        entity.setFilePath(dto.getFilePath());
        entity.setCreateDate(new Date());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setJsVersion(dto.getJsVersion());
        this.insert((Object)entity);
        this.changeJsAnalysisFile();
    }

    private void changeJsAnalysisFile() throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        String parseJsPath = this.sysSystemConfService.getConfValue("100027", null);
        DataExtractJsEntity entity = (DataExtractJsEntity)((DataExtractJsDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"IS_OPEN", (Object)1));
        if (null != entity) {
            FileUtils.copyFile((String)(ftpPath + "/" + entity.getFilePath()), (String)parseJsPath, (String)"extractDatas.js");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateVersion(DataExtractJsVersionDTO dto) throws IOException {
        DataExtractJsEntity entity = new DataExtractJsEntity();
        if (dto.getIsOpen() == 1) {
            entity = new DataExtractJsEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DataExtractJsEntity();
        entity.setId(dto.getId());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setJsVersion(dto.getJsVersion());
        this.updateById((Object)entity);
        this.changeJsAnalysisFile();
    }

    public DataExtractJsVersionDTO getInfo(String id) {
        DataExtractJsEntity entity = (DataExtractJsEntity)((DataExtractJsDao)this.baseDao).selectById((Serializable)((Object)id));
        return (DataExtractJsVersionDTO)ConvertUtils.sourceToTarget((Object)entity, DataExtractJsVersionDTO.class);
    }

    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(ChangeOpenParam data) throws IOException {
        DataExtractJsEntity entity = new DataExtractJsEntity();
        if (data.getIsOpen() == 1) {
            entity = new DataExtractJsEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DataExtractJsEntity();
        entity.setIsOpen(data.getIsOpen());
        entity.setId(data.getId());
        this.updateById((Object)entity);
        this.changeJsAnalysisFile();
    }

    public String getOpenJs() {
        DataExtractJsEntity entity = (DataExtractJsEntity)((DataExtractJsDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"IS_OPEN", (Object)1));
        if (null != entity) {
            return entity.getFilePath();
        }
        return null;
    }
}

