/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.jsversion.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.jsversion.dto.OboxDTO;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.huimu.modules.jsversion.param.GetJsVersionPageParam;
import io.huimu.modules.jsversion.service.OboxService;
import io.huimu.modules.jsversion.vo.OboxVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/obox/version"})
@Api(tags={"OBOX\u7248\u672c\u7ba1\u7406"})
public class OboxController {
    @Autowired
    private OboxService oboxService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetJsVersionPageParam.class)
    public Result<PageData<OboxDTO>> page(@RequestBody EncryptedReq<GetJsVersionPageParam> req) throws IllegalAccessException {
        GetJsVersionPageParam dto = (GetJsVersionPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        PageData page = this.oboxService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"pushVersion"})
    @ApiOperation(value="\u53d1\u5e03\u7248\u672c")
    @LogOperation(value="\u53d1\u5e03\u7248\u672c", module="\u6570\u636e\u63d0\u53d6js\u89e3\u6790\u7248\u672c\u7ba1\u7406", operationType=1)
    public Result pushVersion(@RequestBody EncryptedReq<OboxDTO> req) {
        OboxDTO dto = (OboxDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.oboxService.pushVersion(dto);
        return new Result();
    }

    @PostMapping(value={"updateVersion"})
    @ApiOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9")
    @LogOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u6570\u636e\u63d0\u53d6js\u89e3\u6790\u7248\u672c\u7ba1\u7406", operationType=2)
    public Result updateVersion(@RequestBody EncryptedReq<OboxDTO> req) {
        OboxDTO dto = (OboxDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.oboxService.updateVersion(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u53d1\u5e03\u7248\u672c\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        OboxDTO dto = this.oboxService.getInfo(((IdParam)req.getData()).getId());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u6570\u636e\u63d0\u53d6js\u89e3\u6790\u7248\u672c\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result delete(@RequestBody EncryptedReq<ArraysParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"\u8bf7\u9009\u62e9\u5220\u9664\u9879"});
        this.oboxService.deleteBatch((String[])ids);
        return new Result();
    }

    @PostMapping(value={"changeStatus"})
    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @LogOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001", module="\u6570\u636e\u63d0\u53d6js\u89e3\u6790\u7248\u672c\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ChangeOpenParam.class)
    public Result changeStatus(@RequestBody EncryptedReq<ChangeOpenParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        this.oboxService.changeStatus((ChangeOpenParam)req.getData());
        return new Result();
    }

    @PostMapping(value={"getOpenObox"})
    @ApiOperation(value="\u83b7\u53d6\u5f00\u542f\u7684Obox")
    public Result getOpenObox() {
        OboxVO dto = this.oboxService.getOpenObox();
        return new Result().ok((Object)dto);
    }
}

