/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.constant.Constant;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.job.dao.ScheduleJobDao;
import io.huimu.modules.job.dto.ScheduleJobDTO;
import io.huimu.modules.job.entity.ScheduleJobEntity;
import io.huimu.modules.job.service.ScheduleJobService;
import io.huimu.modules.job.utils.ScheduleUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleJobServiceImpl
extends BaseServiceImpl<ScheduleJobDao, ScheduleJobEntity>
implements ScheduleJobService {
    @Autowired
    private Scheduler scheduler;

    public PageData<ScheduleJobDTO> page(Map<String, Object> params) {
        IPage page = ((ScheduleJobDao)this.baseDao).selectPage(this.getPage(params, "create_date", false), (Wrapper)this.getWrapper(params));
        return this.getPageData(page, ScheduleJobDTO.class);
    }

    public ScheduleJobDTO get(String id) {
        ScheduleJobEntity entity = (ScheduleJobEntity)((ScheduleJobDao)this.baseDao).selectById((Serializable)((Object)id));
        return (ScheduleJobDTO)ConvertUtils.sourceToTarget((Object)entity, ScheduleJobDTO.class);
    }

    private QueryWrapper<ScheduleJobEntity> getWrapper(Map<String, Object> params) {
        String beanName = (String)params.get("beanName");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like(StringUtils.isNotBlank((CharSequence)beanName), (Object)"bean_name", (Object)beanName);
        return wrapper;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(ScheduleJobDTO dto) {
        ScheduleJobEntity entity = (ScheduleJobEntity)ConvertUtils.sourceToTarget((Object)dto, ScheduleJobEntity.class);
        entity.setStatus(Integer.valueOf(Constant.ScheduleStatus.NORMAL.getValue()));
        this.insert((Object)entity);
        ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ScheduleJobDTO dto) {
        ScheduleJobEntity entity = (ScheduleJobEntity)ConvertUtils.sourceToTarget((Object)dto, ScheduleJobEntity.class);
        ScheduleUtils.updateScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)entity);
        this.updateById((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(String[] ids) {
        for (String id : ids) {
            ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (String)id);
        }
        this.deleteBatchIds(Arrays.asList(ids));
    }

    public int updateBatch(String[] ids, int status) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("ids", ids);
        map.put("status", status);
        return ((ScheduleJobDao)this.baseDao).updateBatch(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(String[] ids) {
        for (String id : ids) {
            ScheduleUtils.run((Scheduler)this.scheduler, (ScheduleJobEntity)((ScheduleJobEntity)this.selectById((Serializable)((Object)id))));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void pause(String[] ids) {
        for (String id : ids) {
            ScheduleUtils.pauseJob((Scheduler)this.scheduler, (String)id);
        }
        this.updateBatch(ids, Constant.ScheduleStatus.PAUSE.getValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public void resume(String[] ids) {
        for (String id : ids) {
            ScheduleUtils.resumeJob((Scheduler)this.scheduler, (String)id);
        }
        this.updateBatch(ids, Constant.ScheduleStatus.NORMAL.getValue());
    }

    public void resetSequence() {
        ((ScheduleJobDao)this.baseDao).resetSequence();
    }

    public void resetLogDataTask() {
        ((ScheduleJobDao)this.baseDao).resetLogDataTask(DateUtils.format((Date)new Date(), (String)"yyyy"));
    }
}

