/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.job.dto.ScheduleJobLogDTO;
import io.huimu.modules.job.param.JobLogPageParam;
import io.huimu.modules.job.service.ScheduleJobLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/scheduleLog"})
@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u65e5\u5fd7"})
public class ScheduleJobLogController {
    @Autowired
    private ScheduleJobLogService scheduleJobLogService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=JobLogPageParam.class)
    public Result<PageData<ScheduleJobLogDTO>> page(@RequestBody EncryptedReq<JobLogPageParam> req) throws IllegalAccessException {
        JobLogPageParam params = (JobLogPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.scheduleJobLogService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"info"})
    @ApiOperation(value="\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<ScheduleJobLogDTO> info(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        ScheduleJobLogDTO log = this.scheduleJobLogService.get(dto.getId());
        return new Result().ok(req.getEncode(), (Object)log);
    }
}

