/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.job.dto.ScheduleJobDTO;
import io.huimu.modules.job.param.JobPageParam;
import io.huimu.modules.job.service.ScheduleJobService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/schedule"})
@Api(tags={"\u5b9a\u65f6\u4efb\u52a1"})
public class ScheduleJobController {
    @Autowired
    private ScheduleJobService scheduleJobService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=JobPageParam.class)
    public Result<PageData<ScheduleJobDTO>> page(@RequestBody EncryptedReq<JobPageParam> req) throws IllegalAccessException {
        JobPageParam params = (JobPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.scheduleJobService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<ScheduleJobDTO> info(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        ScheduleJobDTO schedule = this.scheduleJobService.get(dto.getId());
        return new Result().ok(req.getEncode(), (Object)schedule);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=ScheduleJobDTO.class)
    public Result save(@RequestBody EncryptedReq<ScheduleJobDTO> req) {
        ScheduleJobDTO dto = (ScheduleJobDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.scheduleJobService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=ScheduleJobDTO.class)
    public Result update(@RequestBody EncryptedReq<ScheduleJobDTO> req) {
        ScheduleJobDTO dto = (ScheduleJobDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.scheduleJobService.update(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result delete(@RequestBody EncryptedReq<ArraysParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u4efb\u52a1"});
        this.scheduleJobService.deleteBatch((String[])ids);
        return new Result();
    }

    @PostMapping(value={"/run"})
    @ApiOperation(value="\u7acb\u5373\u6267\u884c")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result run(@RequestBody EncryptedReq<ArraysParam> req) {
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"\u8bf7\u9009\u62e9\u7acb\u5373\u6267\u884c\u7684\u4efb\u52a1"});
        this.scheduleJobService.run((String[])ids);
        return new Result();
    }

    @PostMapping(value={"/pause"})
    @ApiOperation(value="\u6682\u505c")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result pause(@RequestBody EncryptedReq<ArraysParam> req) {
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"\u8bf7\u9009\u62e9\u6682\u505c\u7684\u4efb\u52a1"});
        this.scheduleJobService.pause((String[])ids);
        return new Result();
    }

    @PostMapping(value={"/resume"})
    @ApiOperation(value="\u6062\u590d")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result resume(@RequestBody EncryptedReq<ArraysParam> req) {
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"\u8bf7\u9009\u62e9\u6062\u590d\u7684\u4efb\u52a1"});
        this.scheduleJobService.resume((String[])ids);
        return new Result();
    }
}

