/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.hisregister.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.hisregister.dto.HisRegisterDTO;
import io.huimu.modules.hisregister.dto.SaveHisRegisterDTO;
import io.huimu.modules.hisregister.param.DeletePatientParam;
import io.huimu.modules.hisregister.param.GetCzPageParam;
import io.huimu.modules.hisregister.param.GetMzPageParam;
import io.huimu.modules.hisregister.param.GetPatientInfoParam;
import io.huimu.modules.hisregister.param.JzParam;
import io.huimu.modules.hisregister.param.RemovePatientParam;
import io.huimu.modules.hisregister.service.HisRegisterService;
import io.huimu.modules.outside.service.QueryPatientService;
import io.huimu.modules.patient.param.QueryHisPatientParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/his/register"})
@Api(tags={"his\u6302\u53f7\u7ba1\u7406"})
public class HisRegisterController {
    @Autowired
    private HisRegisterService hisRegisterService;
    @Autowired
    private QueryPatientService queryPatientService;

    @PostMapping(value={"mzPage"})
    @ApiOperation(value="\u95e8\u8bca\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetMzPageParam.class)
    public Result<PageData<HisRegisterDTO>> page(@RequestBody EncryptedReq<GetMzPageParam> req) throws IllegalAccessException {
        GetMzPageParam data = (GetMzPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.hisRegisterService.mzPage(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"qgMzPage"})
    @ApiOperation(value="\u5c48\u5149\u95e8\u8bca\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetMzPageParam.class)
    public Result<PageData<HisRegisterDTO>> qgMzPage(@RequestBody EncryptedReq<GetMzPageParam> req) throws IllegalAccessException {
        GetMzPageParam data = (GetMzPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.hisRegisterService.qgMzPage(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"qgCzPage"})
    @ApiOperation(value="\u5c48\u5149\u521d\u8bca\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetCzPageParam.class)
    public Result<PageData<HisRegisterDTO>> qgCzPage(@RequestBody EncryptedReq<GetCzPageParam> req) throws IllegalAccessException {
        GetCzPageParam data = (GetCzPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.hisRegisterService.qgCzPage(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"jz"})
    @ApiOperation(value="\u63a5\u8bca")
    @DecryptAndVerify(decryptedClass=JzParam.class)
    public Result jz(@RequestBody EncryptedReq<JzParam> req) {
        JzParam data = (JzParam)req.getData();
        this.hisRegisterService.jz(data);
        return new Result();
    }

    @PostMapping(value={"qgYjPage"})
    @ApiOperation(value="\u5c48\u5149\u9884\u68c0\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetMzPageParam.class)
    public Result<PageData<HisRegisterDTO>> qgYjPage(@RequestBody EncryptedReq<GetMzPageParam> req) throws IllegalAccessException {
        GetMzPageParam data = (GetMzPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.hisRegisterService.qgYjPage(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getHisQgPatient"})
    @ApiOperation(value="\u83b7\u53d6\u5c48\u5149\u60a3\u8005\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=QueryHisPatientParam.class)
    public Result<List<HisRegisterDTO>> getHisQgPatient(@RequestBody EncryptedReq<QueryHisPatientParam> req) {
        QueryHisPatientParam data = (QueryHisPatientParam)req.getData();
        List dto = this.queryPatientService.queryHisQgPatient(data);
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"getPatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetPatientInfoParam.class)
    public Result<HisRegisterDTO> getPatientInfo(@RequestBody EncryptedReq<GetPatientInfoParam> req) throws IllegalAccessException {
        GetPatientInfoParam data = (GetPatientInfoParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        Map params = MapUtils.object2Map((Object)data);
        HisRegisterDTO dto = this.hisRegisterService.getPatientInfo(params);
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"updatePatient"})
    @ApiOperation(value="\u4fee\u6539\u6302\u53f7\u4fe1\u606f")
    @LogOperation(value="\u4fee\u6539\u6302\u53f7\u4fe1\u606f", module="his\u6302\u53f7\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=HisRegisterDTO.class)
    public Result updatePatient(@RequestBody EncryptedReq<HisRegisterDTO> req) {
        HisRegisterDTO data = (HisRegisterDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.hisRegisterService.updatePatient(data);
        return new Result();
    }

    @PostMapping(value={"removePatient"})
    @ApiOperation(value="\u79fb\u9664\u60a3\u8005")
    @LogOperation(value="\u79fb\u9664\u60a3\u8005", module="his\u6302\u53f7\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=RemovePatientParam.class)
    public Result removePatient(@RequestBody EncryptedReq<RemovePatientParam> req) {
        RemovePatientParam data = (RemovePatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.hisRegisterService.removePatient(data);
        return new Result();
    }

    @PostMapping(value={"deletePatient"})
    @ApiOperation(value="\u5220\u9664\u6302\u53f7\u4fe1\u606f")
    @LogOperation(value="\u5220\u9664\u6302\u53f7\u4fe1\u606f", module="his\u6302\u53f7\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=DeletePatientParam.class)
    public Result<HisRegisterDTO> deletePatient(@RequestBody EncryptedReq<DeletePatientParam> req) throws IllegalAccessException {
        DeletePatientParam data = (DeletePatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.hisRegisterService.deletePatient(data);
        return new Result();
    }

    @PostMapping(value={"savePatient"})
    @ApiOperation(value="\u65b0\u589e\u6302\u53f7\u4fe1\u606f")
    @LogOperation(value="\u65b0\u589e\u6302\u53f7\u4fe1\u606f", module="his\u6302\u53f7\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveHisRegisterDTO.class)
    public Result<HisRegisterDTO> savePatient(@RequestBody EncryptedReq<SaveHisRegisterDTO> req) {
        SaveHisRegisterDTO data = (SaveHisRegisterDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.hisRegisterService.savePatient(data);
        return new Result();
    }
}

