/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.examdataimport.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.modules.examdataimport.dao.ExamDataImportDao;
import io.huimu.modules.examdataimport.entity.ExamDataImportEntity;
import io.huimu.modules.examdataimport.service.ExamDataImportService;
import io.huimu.modules.examdataimport.vo.ImportDataListVO;
import io.huimu.modules.examdataimport.vo.ImportDataVO;
import io.huimu.modules.examdataimport.vo.KeyConfVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamDataImportServiceImpl
extends BaseServiceImpl<ExamDataImportDao, ExamDataImportEntity>
implements ExamDataImportService {
    public static Map<String, List<Map<String, String>>> groupByValue(List<Map<String, String>> list, String key) {
        HashMap<String, List<Map<String, String>>> groups = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> map : list) {
            String value = map.get(key);
            if (value == null) continue;
            List groupList = groups.computeIfAbsent(value, k -> new ArrayList());
            groupList.add(map);
        }
        return groups;
    }

    public List<ExamDataImportEntity> getList() {
        return ((ExamDataImportDao)this.baseDao).getList();
    }

    public ImportDataListVO getExamData(String id, String patientId, String orgCode) {
        ExamDataImportEntity entity = (ExamDataImportEntity)((ExamDataImportDao)this.baseDao).selectById((Serializable)((Object)id));
        if (null == entity) {
            throw new RenException("\u914d\u7f6e\u9879\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List keyConfVOList = ((ExamDataImportDao)this.baseDao).selectKeyConf();
        ImportDataListVO resData = new ImportDataListVO();
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewName())) {
            resData.setNoEyeTypeData(this.handleExamData(entity.getSelectViewName(), patientId, keyConfVOList));
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewNameOd())) {
            resData.setOdData(this.handleExamData(entity.getSelectViewNameOd(), patientId, keyConfVOList));
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewNameOs())) {
            resData.setOsData(this.handleExamData(entity.getSelectViewNameOs(), patientId, keyConfVOList));
        }
        return resData;
    }

    public Map<String, String> getImportData(String patientId, Integer flag, String id, String orgCode) {
        Map<String, String> resMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)id)) {
            List list = ((ExamDataImportDao)this.baseDao).selectList((Wrapper)new QueryWrapper());
            if (CollUtil.isEmpty((Collection)list)) {
                return resMap;
            }
            resMap = this.getExamData(list, patientId, flag, orgCode);
            resMap.remove("PATIENT_ID");
            resMap.remove("ORG_CODE");
            resMap.remove("EXAM_TIME");
            resMap.remove("EXAM_DATE");
            return resMap;
        }
        ExamDataImportEntity entity = (ExamDataImportEntity)((ExamDataImportDao)this.baseDao).selectById((Serializable)((Object)id));
        if (null == entity) {
            throw new RenException("\u914d\u7f6e\u9879\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        resMap = this.getExamData(Arrays.asList(entity), patientId, flag, orgCode);
        resMap.remove("PATIENT_ID");
        resMap.remove("ORG_CODE");
        resMap.remove("EXAM_TIME");
        resMap.remove("EXAM_DATE");
        return resMap;
    }

    private Map<String, String> getExamData(List<ExamDataImportEntity> list, String patientId, Integer flag, String orgCode) {
        HashMap resMap = new HashMap();
        List<CompletableFuture> futures = list.stream().map(p -> CompletableFuture.supplyAsync(() -> this.handleData(p, patientId, flag))).collect(Collectors.toList());
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        allFutures.join();
        List results = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        for (Map map : results) {
            if (CollectionUtils.isEmpty((Map)map)) continue;
            resMap.putAll(map);
        }
        return MapUtils.transformUpperCase(resMap);
    }

    private Map<String, String> handleData(ExamDataImportEntity entity, String patientId, Integer flag) {
        Map dataMap;
        HashMap<String, String> resMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewName())) {
            dataMap = ((ExamDataImportDao)this.baseDao).getImportData(entity.getSelectViewName(), patientId, flag, DateUtils.format((Date)new Date()));
            MapUtils.transformUpperCase((Map)dataMap);
            if (!CollectionUtils.isEmpty((Map)dataMap)) {
                resMap.putAll(dataMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewNameOd()) && !CollectionUtils.isEmpty((Map)(dataMap = ((ExamDataImportDao)this.baseDao).getImportData(entity.getSelectViewNameOd(), patientId, flag, DateUtils.format((Date)new Date()))))) {
            resMap.putAll(dataMap);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSelectViewNameOs()) && !CollectionUtils.isEmpty((Map)(dataMap = ((ExamDataImportDao)this.baseDao).getImportData(entity.getSelectViewNameOs(), patientId, flag, DateUtils.format((Date)new Date()))))) {
            resMap.putAll(dataMap);
        }
        return resMap;
    }

    public List<List<ImportDataVO>> handleExamData(String selectViewName, String patientId, List<KeyConfVO> keyConfVOList) {
        ArrayList<List<ImportDataVO>> dataList = new ArrayList<List<ImportDataVO>>();
        List examDataList = ((ExamDataImportDao)this.baseDao).selectExamData(patientId, selectViewName);
        if (CollUtil.isEmpty((Collection)examDataList)) {
            return dataList;
        }
        for (Map dataMap : examDataList) {
            dataMap = MapUtils.transformUpperCase((Map)dataMap);
            ArrayList<ImportDataVO> dataVOList = new ArrayList<ImportDataVO>();
            ArrayList<String> excludeFiled = new ArrayList<String>();
            excludeFiled.add("PATIENT_ID");
            excludeFiled.add("EXAM_DATE");
            excludeFiled.add("ORG_CODE");
            excludeFiled.add("EYE_TYPE");
            for (String dataKey : dataMap.keySet()) {
                if (excludeFiled.contains(StringUtils.upperCase((String)dataKey))) continue;
                ImportDataVO dataVO = new ImportDataVO();
                dataVO.setKey(dataKey);
                dataVO.setValue((Object)(dataMap.get(dataKey) == null ? "" : dataMap.get(dataKey)));
                Optional<KeyConfVO> first = keyConfVOList.stream().filter(conf -> conf.getKeyName().equals(dataKey)).findFirst();
                if (first.isPresent()) {
                    dataVO.setNote(first.get().getKeyNote());
                } else {
                    dataVO.setNote(dataKey);
                }
                dataVOList.add(dataVO);
            }
            dataList.add(dataVOList);
        }
        return dataList;
    }
}

