/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.examdataimport.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ExamPatientIdParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.KeyNoteParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.examdataimport.dto.DataConfDTO;
import io.huimu.modules.examdataimport.dto.ExamDataImportDTO;
import io.huimu.modules.examdataimport.entity.ExamDataImportEntity;
import io.huimu.modules.examdataimport.entity.ImportDataConfEntity;
import io.huimu.modules.examdataimport.service.ExamDataImportService;
import io.huimu.modules.examdataimport.service.ImportDataConfService;
import io.huimu.modules.examdataimport.vo.ImportDataListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/data/import"})
@Api(tags={"\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406"})
public class ExamDataImportController {
    @Autowired
    private ExamDataImportService examPortImportService;
    @Autowired
    private ImportDataConfService dataConfService;

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<List<ExamDataImportEntity>> getList(@RequestBody EncryptedReq<NoParam> req) {
        List resList = this.examPortImportService.getList();
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<ExamDataImportDTO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam data = (IdParam)req.getData();
        AssertUtils.isBlank((String)data.getId(), (String[])new String[]{"id"});
        ExamDataImportEntity entity = (ExamDataImportEntity)this.examPortImportService.selectById((Serializable)((Object)data.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, ExamDataImportDTO.class));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58\u8bbe\u7f6e")
    @LogOperation(value="\u4fdd\u5b58\u8bbe\u7f6e", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=ExamDataImportDTO.class)
    public Result save(@RequestBody EncryptedReq<ExamDataImportDTO> req) {
        ExamDataImportDTO dto = (ExamDataImportDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.examPortImportService.insert(ConvertUtils.sourceToTarget((Object)dto, ExamDataImportEntity.class));
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u8bbe\u7f6e")
    @LogOperation(value="\u4fee\u6539\u8bbe\u7f6e", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=ExamDataImportDTO.class)
    public Result update(@RequestBody EncryptedReq<ExamDataImportDTO> req) {
        ExamDataImportDTO dto = (ExamDataImportDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.examPortImportService.updateById(ConvertUtils.sourceToTarget((Object)dto, ExamDataImportEntity.class));
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u8bbe\u7f6e")
    @LogOperation(value="\u5220\u9664\u8bbe\u7f6e", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"id"});
        this.examPortImportService.deleteById((Serializable)((Object)param.getId()));
        return new Result();
    }

    @PostMapping(value={"getExamData"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u6570\u636e")
    @DecryptAndVerify(decryptedClass=ExamPatientIdParam.class)
    public Result<ImportDataListVO> getExamData(@RequestBody EncryptedReq<ExamPatientIdParam> req) {
        ExamPatientIdParam param = (ExamPatientIdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"id"});
        AssertUtils.isBlank((String)param.getPatientId(), (String[])new String[]{"\u60a3\u8005id"});
        ImportDataListVO vo = this.examPortImportService.getExamData(param.getId(), param.getPatientId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5b57\u6bb5\u6ce8\u91ca\u914d\u7f6e\u5206\u9875")
    @DecryptAndVerify(decryptedClass=KeyNoteParam.class)
    public Result<PageData<ImportDataConfEntity>> page(@RequestBody EncryptedReq<KeyNoteParam> req) throws IllegalAccessException {
        KeyNoteParam param = (KeyNoteParam)req.getData();
        Map params = MapUtils.object2Map((Object)param);
        PageData page = this.dataConfService.page(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"saveDataConf"})
    @ApiOperation(value="\u4fdd\u5b58\u5b57\u6bb5\u6ce8\u91ca")
    @LogOperation(value="\u4fdd\u5b58\u5b57\u6bb5\u6ce8\u91ca", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=DataConfDTO.class)
    public Result saveDataConf(@RequestBody EncryptedReq<DataConfDTO> req) {
        DataConfDTO dto = (DataConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        ImportDataConfEntity confEntity = (ImportDataConfEntity)this.dataConfService.selectById((Serializable)((Object)dto.getKeyName()));
        if (confEntity != null) {
            return new Result().error("\u8be5\u5b57\u6bb5\u5df2\u6dfb\u52a0\u6ce8\u91ca\u914d\u7f6e");
        }
        this.dataConfService.insert(ConvertUtils.sourceToTarget((Object)dto, ImportDataConfEntity.class));
        return new Result();
    }

    @PostMapping(value={"updateDataConf"})
    @ApiOperation(value="\u4fee\u6539\u5b57\u6bb5\u6ce8\u91ca")
    @LogOperation(value="\u4fee\u6539\u5b57\u6bb5\u6ce8\u91ca", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=DataConfDTO.class)
    public Result updateDataConf(@RequestBody EncryptedReq<DataConfDTO> req) {
        DataConfDTO dto = (DataConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.dataConfService.updateById(ConvertUtils.sourceToTarget((Object)dto, ImportDataConfEntity.class));
        return new Result();
    }

    @PostMapping(value={"deleteDataConf"})
    @ApiOperation(value="\u5220\u9664\u5b57\u6bb5\u6ce8\u91ca\u8bbe\u7f6e")
    @LogOperation(value="\u5220\u9664\u5b57\u6bb5\u6ce8\u91ca\u8bbe\u7f6e", module="\u68c0\u67e5\u6570\u636e\uff0c\u4e00\u952e\u5f15\u5165\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteDataConf(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"keyName"});
        this.dataConfService.deleteById((Serializable)((Object)param.getId()));
        return new Result();
    }

    @PostMapping(value={"getImportData"})
    @ApiOperation(value="\u4e00\u952e\u5f15\u5165\u6570\u636e")
    @DecryptAndVerify(decryptedClass=ExamPatientIdParam.class)
    public Result getImportData(@RequestBody EncryptedReq<ExamPatientIdParam> req) {
        ExamPatientIdParam param = (ExamPatientIdParam)req.getData();
        AssertUtils.isNull((Object)param.getFlag(), (String[])new String[]{"\u6807\u5fd7\u4f4d"});
        AssertUtils.isBlank((String)param.getPatientId(), (String[])new String[]{"\u60a3\u8005id"});
        Map resMap = this.examPortImportService.getImportData(param.getPatientId(), param.getFlag(), param.getId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)resMap);
    }

    @PostMapping(value={"getAllView"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5168\u90e8\u89c6\u56fe")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getAllView(@RequestBody EncryptedReq<NoParam> req) {
        List views = this.dataConfService.getAllView();
        return new Result().ok(req.getEncode(), (Object)views);
    }
}

