/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.doctorempower.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.doctorempower.dto.AddDoctorEmpowerDTO;
import io.huimu.modules.doctorempower.param.GetBsqListParam;
import io.huimu.modules.doctorempower.param.GetMainDoctorSignParam;
import io.huimu.modules.doctorempower.param.GetSqListParam;
import io.huimu.modules.doctorempower.service.SysDoctorEmpowerService;
import io.huimu.modules.doctorempower.vo.DoctorEmpowerVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/doctor/empower"})
@Api(tags={"\u533b\u751f\u6388\u6743\u7ba1\u7406"})
public class SysDoctorEmpowerController {
    @Autowired
    private SysDoctorEmpowerService sysDoctorEmpowerService;

    @PostMapping(value={"saveOrUpdate"})
    @ApiOperation(value="\u533b\u751f\u6388\u6743")
    @LogOperation(value="\u533b\u751f\u6388\u6743", module="\u533b\u751f\u6388\u6743\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=AddDoctorEmpowerDTO.class)
    public Result saveOrUpdate(@RequestBody EncryptedReq<AddDoctorEmpowerDTO> req) {
        AddDoctorEmpowerDTO dto = (AddDoctorEmpowerDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysDoctorEmpowerService.saveOrUpdate(dto);
        return new Result();
    }

    @GetMapping(value={"getEmpowerInfo"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u6388\u6743\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getEmpowerInfo(@RequestBody EncryptedReq<NoParam> req) {
        DoctorEmpowerVO vo = this.sysDoctorEmpowerService.getEmpowerInfo(SecurityUser.getUser().getEmployeeId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @GetMapping(value={"getSqList"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetSqListParam.class)
    public Result getSqPage(@RequestBody EncryptedReq<GetSqListParam> req) throws IllegalAccessException {
        GetSqListParam dto = (GetSqListParam)req.getData();
        PageData pageData = this.sysDoctorEmpowerService.getSqPage(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)pageData);
    }

    @GetMapping(value={"getBsqList"})
    @ApiOperation(value="\u83b7\u53d6\u88ab\u6388\u6743\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetBsqListParam.class)
    public Result getBsqPage(@RequestBody EncryptedReq<GetBsqListParam> req) throws IllegalAccessException {
        GetBsqListParam dto = (GetBsqListParam)req.getData();
        PageData pageData = this.sysDoctorEmpowerService.getBsqPage(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)pageData);
    }

    @GetMapping(value={"getMainDoctorSign"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u5200\u533b\u751f\u7b7e\u540d")
    @DecryptAndVerify(decryptedClass=GetMainDoctorSignParam.class)
    public Result getMainDoctorSign(@RequestBody EncryptedReq<GetMainDoctorSignParam> req) {
        GetMainDoctorSignParam dto = (GetMainDoctorSignParam)req.getData();
        SysUserDTO sysUserDTO = this.sysDoctorEmpowerService.getMainDoctorSign(dto.getOperaPatientId());
        return new Result().ok(req.getEncode(), (Object)sysUserDTO);
    }
}

