/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictTransmitMapper;
import io.huimu.modules.dict.dto.DictTransmitDto;
import io.huimu.modules.dict.entity.DictTransmitEntity;
import io.huimu.modules.dict.param.GetTransmitInfoParam;
import io.huimu.modules.dict.service.DictDataExtractShowService;
import io.huimu.modules.dict.service.DictTransmitService;
import io.huimu.modules.dict.vo.DictTransmitVO;
import io.huimu.modules.littlecheck.entity.SysExamDeviceConfEntity;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTransmitServiceImpl
extends BaseServiceImpl<DictTransmitMapper, DictTransmitEntity>
implements DictTransmitService {
    @Autowired
    private SysExamDeviceConfService examDeviceConfService;
    @Autowired
    private DictDataExtractShowService dictDataExtractShowService;

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(DictTransmitDto dto) {
        ((DictTransmitMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"device_id", (Object)dto.getDeviceId()));
        DictTransmitEntity entity = (DictTransmitEntity)ConvertUtils.sourceToTarget((Object)dto, DictTransmitEntity.class);
        if (CollectionUtils.isNotEmpty((Collection)dto.getFieldIds())) {
            entity.setSelectField(String.join((CharSequence)"#", dto.getFieldIds()));
        }
        this.insert((Object)entity);
        SysExamDeviceConfEntity confEntity = new SysExamDeviceConfEntity();
        confEntity.setLocalIp(dto.getLocalIp());
        confEntity.setWebsocketPort(String.valueOf(dto.getWebSocketPort()));
        confEntity.setIsAutoMate(dto.getIsAutoMate());
        confEntity.setIsAutoMateDcm(dto.getIsAutoMateDcm());
        confEntity.setAutoMateDays(dto.getAutoMateDays());
        confEntity.setIsPyZw(dto.getIsPyZw());
        confEntity.setPdfDir(dto.getPdfDir());
        confEntity.setIsSjhc(dto.getIsSjhc());
        confEntity.setDataExtractConfId(dto.getDataExtractConfId());
        confEntity.setDataExtractType(dto.getDataExtractType());
        this.examDeviceConfService.update((Object)confEntity, (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getDeviceId()));
        this.dictDataExtractShowService.saveOrUpdate(dto.getDeviceId(), dto.getDataExtractShowConfIds());
    }

    public DictTransmitVO getInfo(GetTransmitInfoParam param) {
        List infoList = ((DictTransmitMapper)this.baseDao).getInfo(param.getDeviceId());
        if (CollectionUtils.isEmpty((Collection)infoList)) {
            return new DictTransmitVO();
        }
        DictTransmitVO info = (DictTransmitVO)infoList.get(0);
        if (StringUtils.isNotBlank((CharSequence)info.getSelectField())) {
            info.setFieldIds(Arrays.asList(info.getSelectField().split("#")));
        }
        info.setDataExtractShowConfIds(this.dictDataExtractShowService.getDataExtractShowConfIds(info.getDeviceId()));
        return info;
    }

    public DictTransmitEntity selectByDeviceId(String deviceId) {
        return (DictTransmitEntity)((DictTransmitMapper)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"device_id", (Object)deviceId));
    }
}

