/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.dict.dao.DictStandardKnowDao;
import io.huimu.modules.dict.entity.DictStandardKnowEntity;
import io.huimu.modules.dict.service.DictStandardKnowService;
import io.huimu.modules.sys.dto.SysKnowledgeDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictStandardKnowServiceImpl
extends BaseServiceImpl<DictStandardKnowDao, DictStandardKnowEntity>
implements DictStandardKnowService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String standardCode, List<String> knowIds) {
        ((DictStandardKnowDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"STANDARD_CODE", (Object)standardCode));
        if (CollUtil.isNotEmpty(knowIds)) {
            ArrayList<DictStandardKnowEntity> list = new ArrayList<DictStandardKnowEntity>();
            for (String knowId : knowIds) {
                DictStandardKnowEntity entity = new DictStandardKnowEntity();
                entity.setStandardCode(standardCode);
                entity.setKnowId(knowId);
                entity.setCreateDate(new Date());
                list.add(entity);
            }
            this.insertBatch(list, 20);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDelByStandardIds(List<String> standardCodes) {
        ((DictStandardKnowDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"STANDARD_CODE", standardCodes));
    }

    public List<String> getKnowIds(String standardCode) {
        return ((DictStandardKnowDao)this.baseDao).getKnowIds(standardCode);
    }

    public List<String> getKnowNames(String standardCode) {
        return ((DictStandardKnowDao)this.baseDao).getKnowNames(standardCode);
    }

    public List<SysKnowledgeDTO> getKnowByStandardCode(String standardCode) {
        return ((DictStandardKnowDao)this.baseDao).getKnowByStandardCode(standardCode);
    }

    public void deleteByKnowIds(List<String> knowIds) {
        ((DictStandardKnowDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"KNOW_ID", knowIds));
    }
}

