/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictServerExeVersionMapper;
import io.huimu.modules.dict.dto.ExeVersionDTO;
import io.huimu.modules.dict.entity.DictServerExeVersionEntity;
import io.huimu.modules.dict.service.DictServerExeVersionService;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServerExeVersionServiceImpl
extends BaseServiceImpl<DictServerExeVersionMapper, DictServerExeVersionEntity>
implements DictServerExeVersionService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public PageData<ExeVersionDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"fileName", "exeVersion"});
        String exeVersion = (String)params.get("exeVersion");
        String fileName = (String)params.get("fileName");
        IPage page = ((DictServerExeVersionMapper)this.baseDao).selectPage(this.getPage(params, null, true), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((CharSequence)exeVersion), (Object)"EXE_VERSION", (Object)exeVersion)).like(StringUtils.isNotBlank((CharSequence)fileName), (Object)"FILE_NAME", (Object)fileName)).orderByDesc((Object)"EXE_VERSION"));
        return this.getPageData(page, ExeVersionDTO.class);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void pushVersion(ExeVersionDTO dto) throws IOException {
        DictServerExeVersionEntity entity;
        if (dto.getIsOpen() == 1) {
            entity = new DictServerExeVersionEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DictServerExeVersionEntity();
        entity.setFileName(dto.getFileName());
        entity.setFilePath(dto.getFilePath());
        entity.setUpdateTime(new Date());
        entity.setUploadTime(new Date());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setExeVersion(dto.getExeVersion());
        this.insert((Object)entity);
    }

    public void updateVersion(ExeVersionDTO dto) {
        DictServerExeVersionEntity entity;
        if (dto.getIsOpen() == 1) {
            entity = new DictServerExeVersionEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DictServerExeVersionEntity();
        entity.setFilePath(null);
        entity.setId(dto.getId());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setExeVersion(dto.getExeVersion());
        entity.setUpdateTime(new Date());
        this.updateById((Object)entity);
    }

    public ExeVersionDTO getInfo(String id) {
        DictServerExeVersionEntity entity = (DictServerExeVersionEntity)((DictServerExeVersionMapper)this.baseDao).selectById((Serializable)((Object)id));
        return (ExeVersionDTO)ConvertUtils.sourceToTarget((Object)entity, ExeVersionDTO.class);
    }

    public void changeStatus(ChangeOpenParam data) {
        DictServerExeVersionEntity entity = new DictServerExeVersionEntity();
        if (data.getIsOpen() == 1) {
            entity = new DictServerExeVersionEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new DictServerExeVersionEntity();
        entity.setIsOpen(data.getIsOpen());
        entity.setId(data.getId());
        this.updateById((Object)entity);
    }

    public String getExePath() {
        DictServerExeVersionEntity entity = (DictServerExeVersionEntity)((DictServerExeVersionMapper)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"IS_OPEN", (Object)1));
        if (entity == null) {
            return null;
        }
        return entity.getFilePath();
    }
}

