/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.dict.dao.DictDeviceExamItemMapper;
import io.huimu.modules.dict.entity.DictDeviceExamItemEntity;
import io.huimu.modules.dict.param.UpdateDeviceItemParam;
import io.huimu.modules.dict.service.DictDeviceExamItemService;
import io.huimu.modules.dict.vo.DictDeviceItemVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DictDeviceExamItemServiceImpl
extends BaseServiceImpl<DictDeviceExamItemMapper, DictDeviceExamItemEntity>
implements DictDeviceExamItemService {
    public void saveOrUpdate(UpdateDeviceItemParam dto) {
        ((DictDeviceExamItemMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"device_id", (Object)dto.getDeviceId()));
        if (CollectionUtils.isEmpty((Collection)dto.getExamineCodeList())) {
            return;
        }
        ArrayList<DictDeviceExamItemEntity> entityList = new ArrayList<DictDeviceExamItemEntity>();
        for (String examineCode : dto.getExamineCodeList()) {
            DictDeviceExamItemEntity entity = new DictDeviceExamItemEntity();
            entity.setDeviceId(dto.getDeviceId());
            entity.setExamineCode(examineCode);
            entityList.add(entity);
        }
        this.insertBatch(entityList);
    }

    public DictDeviceItemVO getInfo(String deviceId) {
        return ((DictDeviceExamItemMapper)this.baseDao).getInfo(deviceId);
    }

    public void delete(String deviceId) {
        ((DictDeviceExamItemMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"device_id", (Object)deviceId));
    }

    public PageData<DictDeviceItemVO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"deviceId"});
        List list = ((DictDeviceExamItemMapper)this.baseDao).getList(params.get("deviceId"));
        int total = list.size();
        long curPage = Long.parseLong((String)params.get("page"));
        long limit = Long.parseLong((String)params.get("limit"));
        list = list.stream().skip((curPage - 1L) * limit).limit(limit).collect(Collectors.toList());
        return new PageData(list, (long)total);
    }

    public List<String> getExamCodeListByDeviceId(String deviceId) {
        return ((DictDeviceExamItemMapper)this.baseDao).getExamCodeListByDeviceId(deviceId);
    }
}

