/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictDataExtractConfDao;
import io.huimu.modules.dict.dto.DictDataExtractConfDTO;
import io.huimu.modules.dict.entity.DictDataExtractConfEntity;
import io.huimu.modules.dict.param.GetParentListParam;
import io.huimu.modules.dict.service.DictDataExtractConfService;
import io.huimu.modules.dict.service.DictDataExtractShowService;
import io.huimu.modules.dict.vo.DictDataExtractConfVO;
import io.huimu.modules.littlecheck.dto.SysExamDeviceConfDTO;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictDataExtractConfServiceImpl
extends BaseServiceImpl<DictDataExtractConfDao, DictDataExtractConfEntity>
implements DictDataExtractConfService {
    @Autowired
    private SysExamDeviceConfService sysExamDeviceConfService;
    @Autowired
    private DictDataExtractShowService dataExtractShowService;

    @Transactional(rollbackFor={Exception.class})
    public void deleteChildren(List<String> ids) {
        ((DictDataExtractConfDao)this.baseDao).deleteBatchIds(ids);
        this.dataExtractShowService.deleteByConfIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteParent(String id) {
        ((DictDataExtractConfDao)this.baseDao).deleteById((Serializable)((Object)id));
        ((DictDataExtractConfDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"pid", (Object)id));
    }

    public void save(DictDataExtractConfDTO param) {
        if (param.getPid().equalsIgnoreCase("0")) {
            if (StringUtils.isBlank((CharSequence)param.getBrand())) {
                throw new RenException("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)param.getModel())) {
                throw new RenException("\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)param.getTableName())) {
                throw new RenException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            Integer count = ((DictDataExtractConfDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"db_key", (Object)param.getDbKey())).eq((Object)"pid", (Object)param.getPid()));
            if (count > 0) {
                throw new RenException("\u76f8\u540c\u7684dbKey\u5df2\u5b58\u5728");
            }
        }
        this.insert(ConvertUtils.sourceToTarget((Object)param, DictDataExtractConfEntity.class));
    }

    public void update(DictDataExtractConfDTO param) {
        if (param.getPid().equalsIgnoreCase("0")) {
            if (StringUtils.isBlank((CharSequence)param.getBrand())) {
                throw new RenException("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)param.getModel())) {
                throw new RenException("\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)param.getTableName())) {
                throw new RenException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            Integer count = ((DictDataExtractConfDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"db_key", (Object)param.getDbKey())).ne((Object)"id", (Object)param.getId())).eq((Object)"pid", (Object)param.getPid()));
            if (count > 0) {
                throw new RenException("\u76f8\u540c\u7684dbKey\u5df2\u5b58\u5728");
            }
        }
        this.updateById(ConvertUtils.sourceToTarget((Object)param, DictDataExtractConfEntity.class));
    }

    public List<DictDataExtractConfDTO> getParentList(GetParentListParam param) {
        List list = ((DictDataExtractConfDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)"0")).eq((Object)"brand", (Object)param.getBrand())).eq((Object)"model", (Object)param.getModel())).orderByAsc((Object)"sort_index"));
        return ConvertUtils.sourceToTarget((Collection)list, DictDataExtractConfDTO.class);
    }

    public List<DictDataExtractConfDTO> getChildrenList(String pid) {
        List list = ((DictDataExtractConfDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)pid)).orderByAsc((Object)"sort_index"));
        return ConvertUtils.sourceToTarget((Collection)list, DictDataExtractConfDTO.class);
    }

    public DictDataExtractConfVO getExtractConfInfo(String deviceId) {
        SysExamDeviceConfDTO deviceConfDTO = this.sysExamDeviceConfService.getConfInfo(deviceId);
        if (null != deviceConfDTO && StringUtils.isNotBlank((CharSequence)deviceConfDTO.getDataExtractConfId())) {
            DictDataExtractConfVO vo = ((DictDataExtractConfDao)this.baseDao).getParentVO(deviceConfDTO.getDataExtractConfId());
            if (null != vo) {
                vo.setChildrenList(((DictDataExtractConfDao)this.baseDao).getDataExtractConfShowInfo(deviceId));
                return vo;
            }
            return null;
        }
        return null;
    }
}

