/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.dict.dto.DictYxbgbjDto;
import io.huimu.modules.dict.entity.DictYxbgbjEntity;
import io.huimu.modules.dict.param.DeviceIdParam;
import io.huimu.modules.dict.service.DictYxbgbjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/yxbgbj"})
@Api(tags={"\u5f71\u50cf\u62a5\u544a\u7f16\u8f91"})
public class DictYxbgbjController {
    @Autowired
    private DictYxbgbjService yxbgbjService;

    @PostMapping(value={"saveOrUpdate"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539")
    @LogOperation(value="\u65b0\u589e", module="\u5f71\u50cf\u62a5\u544a\u7f16\u8f91\u914d\u7f6e", operationType=1)
    @DecryptAndVerify(decryptedClass=DictYxbgbjDto.class)
    public Result save(@RequestBody EncryptedReq<DictYxbgbjDto> req) {
        DictYxbgbjDto dto = (DictYxbgbjDto)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.yxbgbjService.saveOrUpdate(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=DeviceIdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<DeviceIdParam> req) {
        DeviceIdParam param = (DeviceIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        DictYxbgbjEntity vo = this.yxbgbjService.getInfo(param.getDeviceId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=DeviceIdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u5f71\u50cf\u62a5\u544a\u7f16\u8f91\u914d\u7f6e", operationType=3)
    public Result batchDel(@RequestBody EncryptedReq<DeviceIdParam> req) {
        DeviceIdParam dto = (DeviceIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.yxbgbjService.deleteById((Serializable)((Object)dto.getDeviceId()));
        return new Result();
    }
}

