/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictTransmitJarDTO;
import io.huimu.modules.dict.param.GetTransmitInfoParam;
import io.huimu.modules.dict.param.GetTransmitJarPageParam;
import io.huimu.modules.dict.service.DictServerExeVersionService;
import io.huimu.modules.dict.service.DictTransmitJarService;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transmit/jar"})
@Api(tags={"\u4e00\u952e\u4f20\u8f93\u5305\u7ba1\u7406"})
public class DictTransmitJarController {
    @Autowired
    private DictServerExeVersionService versionService;
    @Autowired
    private DictTransmitJarService jarService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetTransmitJarPageParam.class)
    public Result<PageData<DictTransmitJarDTO>> page(@RequestBody EncryptedReq<GetTransmitJarPageParam> req) throws IllegalAccessException {
        GetTransmitJarPageParam dto = (GetTransmitJarPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        PageData page = this.jarService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"pushVersion"})
    @ApiOperation(value="\u53d1\u5e03\u7248\u672c")
    @LogOperation(value="\u53d1\u5e03\u7248\u672c", module="\u4e00\u952e\u4f20\u8f93\u5305\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=DictTransmitJarDTO.class)
    public Result pushVersion(@RequestBody EncryptedReq<DictTransmitJarDTO> req) throws IOException {
        DictTransmitJarDTO dto = (DictTransmitJarDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.jarService.pushVersion(dto);
        return new Result();
    }

    @PostMapping(value={"updateVersion"})
    @ApiOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9")
    @LogOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u4e00\u952e\u4f20\u8f93\u5305\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=DictTransmitJarDTO.class)
    public Result updateVersion(@RequestBody EncryptedReq<DictTransmitJarDTO> req) {
        DictTransmitJarDTO dto = (DictTransmitJarDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.jarService.updateVersion(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u53d1\u5e03\u7248\u672c\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        DictTransmitJarDTO dto = this.jarService.getInfo(((IdParam)req.getData()).getId());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u4e00\u952e\u4f20\u8f93\u5305\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        String id = ((IdParam)req.getData()).getId();
        this.jarService.deleteById((Serializable)((Object)id));
        return new Result();
    }

    @PostMapping(value={"changeStatus"})
    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @LogOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001", module="\u4e00\u952e\u4f20\u8f93\u5305\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ChangeOpenParam.class)
    public Result changeStatus(@RequestBody EncryptedReq<ChangeOpenParam> req) throws IOException {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        this.jarService.changeStatus((ChangeOpenParam)req.getData());
        return new Result();
    }

    @PostMapping(value={"getJarContent"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u952e\u4f20\u8f93\u5305\u5185\u5bb9")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getJarContent(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        IdParam idParam = (IdParam)req.getData();
        String content = this.jarService.getJarContent(idParam.getId());
        return new Result().ok(req.getEncode(), (Object)content);
    }

    @PostMapping(value={"getJarList"})
    @ApiOperation(value="\u6839\u636e\u8bbe\u5907id\u83b7\u53d6\u4e00\u952e\u4f20\u8f93\u5305\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetTransmitInfoParam.class)
    public Result getJarList(@RequestBody EncryptedReq<GetTransmitInfoParam> req) {
        GetTransmitInfoParam param = (GetTransmitInfoParam)req.getData();
        List vo = this.jarService.getJarList(param.getDeviceId(), param.getFlag(), param.getIsOpen());
        return new Result().ok(req.getEncode(), (Object)vo);
    }
}

