/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictTransmitFieldDTO;
import io.huimu.modules.dict.entity.DictTransmitFieldEntity;
import io.huimu.modules.dict.param.DeviceIdParam;
import io.huimu.modules.dict.service.DictTransmitFieldService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transmit/field"})
@Api(tags={"\u4e00\u952e\u4f20\u8f93\u5b57\u6bb5\u7ba1\u7406"})
public class DictTransmitFieldController {
    @Autowired
    private DictTransmitFieldService fieldService;

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5b57\u6bb5\u5b57\u5178\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<List<DictTransmitFieldDTO>> getList(@RequestBody EncryptedReq<NoParam> req) throws IllegalAccessException {
        List list = this.fieldService.getList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u65b0\u589e", module="\u4e00\u952e\u4f20\u8f93\u5b57\u6bb5\u5b57\u5178", operationType=1)
    @DecryptAndVerify(decryptedClass=DictTransmitFieldDTO.class)
    public Result save(@RequestBody EncryptedReq<DictTransmitFieldDTO> req) {
        DictTransmitFieldDTO dto = (DictTransmitFieldDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.fieldService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539", module="\u4e00\u952e\u4f20\u8f93\u5b57\u6bb5\u5b57\u5178", operationType=2)
    @DecryptAndVerify(decryptedClass=DictTransmitFieldDTO.class)
    public Result update(@RequestBody EncryptedReq<DictTransmitFieldDTO> req) {
        DictTransmitFieldDTO dto = (DictTransmitFieldDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.fieldService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictTransmitFieldEntity vo = this.fieldService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"getInfoList"})
    @ApiOperation(value="\u83b7\u53d6\u52fe\u9009\u7684\u5b57\u6bb5\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=DeviceIdParam.class)
    public Result getInfoList(@RequestBody EncryptedReq<DeviceIdParam> req) {
        DeviceIdParam deviceIdParam = (DeviceIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)deviceIdParam, (Class[])new Class[0]);
        List list = this.fieldService.getInfoList(deviceIdParam.getDeviceId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u4e00\u952e\u4f20\u8f93\u5b57\u6bb5\u5b57\u5178", operationType=3)
    public Result batchDel(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.fieldService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }
}

