/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictSysMenuChildDTO;
import io.huimu.modules.dict.entity.DictSysMenuChildEntity;
import io.huimu.modules.dict.param.DictSysMenuChildPageParam;
import io.huimu.modules.dict.service.DictSysMenuChildService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu/child"})
@Api(tags={"\u7cfb\u7edf\u5b50\u83dc\u5355\u7ba1\u7406"})
public class DictSysMenuChildController {
    @Autowired
    private DictSysMenuChildService dictSysMenuChildService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=DictSysMenuChildPageParam.class)
    public Result<PageData<DictSysMenuChildDTO>> page(@RequestBody EncryptedReq<DictSysMenuChildPageParam> req) throws IllegalAccessException {
        DictSysMenuChildPageParam dto = (DictSysMenuChildPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.dictSysMenuChildService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=DictSysMenuChildDTO.class)
    @LogOperation(value="\u4fdd\u5b58", module="\u7cfb\u7edf\u5b50\u83dc\u5355\u7ba1\u7406", operationType=1)
    public Result save(@RequestBody EncryptedReq<DictSysMenuChildDTO> req) {
        DictSysMenuChildDTO dto = (DictSysMenuChildDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictSysMenuChildService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=DictSysMenuChildDTO.class)
    @LogOperation(value="\u4fee\u6539", module="\u7cfb\u7edf\u5b50\u83dc\u5355\u7ba1\u7406", operationType=2)
    public Result update(@RequestBody EncryptedReq<DictSysMenuChildDTO> req) {
        DictSysMenuChildDTO dto = (DictSysMenuChildDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictSysMenuChildService.update(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u7cfb\u7edf\u5b50\u83dc\u5355\u7ba1\u7406", operationType=3)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictSysMenuChildService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictSysMenuChildEntity en = (DictSysMenuChildEntity)this.dictSysMenuChildService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)en, DictSysMenuChildDTO.class));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.dictSysMenuChildService.getList();
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

