/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictOperaParamDTO;
import io.huimu.modules.dict.entity.DictOperaParamEntity;
import io.huimu.modules.dict.param.DictOperaParamList;
import io.huimu.modules.dict.param.DictOperaParamPage;
import io.huimu.modules.dict.service.DictOperaParamService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/opera/param"})
@Api(tags={"\u5c48\u5149\u624b\u672f\u53c2\u6570\u7ba1\u7406"})
public class DictOperaParamController {
    @Autowired
    private DictOperaParamService dictOperaParamService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=DictOperaParamPage.class)
    public Result<PageData<DictOperaParamDTO>> page(@RequestBody EncryptedReq<DictOperaParamPage> req) throws IllegalAccessException {
        DictOperaParamPage dto = (DictOperaParamPage)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.dictOperaParamService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=DictOperaParamDTO.class)
    @LogOperation(value="\u4fdd\u5b58", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=1)
    public Result save(@RequestBody EncryptedReq<DictOperaParamDTO> req) {
        DictOperaParamDTO dto = (DictOperaParamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictOperaParamService.insert(ConvertUtils.sourceToTarget((Object)dto, DictOperaParamEntity.class));
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=DictOperaParamDTO.class)
    @LogOperation(value="\u4fee\u6539", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=2)
    public Result update(@RequestBody EncryptedReq<DictOperaParamDTO> req) {
        DictOperaParamDTO dto = (DictOperaParamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictOperaParamService.updateById(ConvertUtils.sourceToTarget((Object)dto, DictOperaParamEntity.class));
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=3)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictOperaParamService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictOperaParamEntity en = (DictOperaParamEntity)this.dictOperaParamService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)en, DictOperaParamDTO.class));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictOperaParamList.class)
    public Result getList(@RequestBody EncryptedReq<DictOperaParamList> req) {
        DictOperaParamList dto = (DictOperaParamList)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.dictOperaParamService.getList(dto.getType());
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

