/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dict.dto.DictExamitemVerifyUserDTO;
import io.huimu.modules.dict.param.DictExamitemVerifyUserParam;
import io.huimu.modules.dict.service.DictExamitemVerifyUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/examitem/verify/user"})
@Api(tags={"\u68c0\u67e5\u9879\u76ee\u4e0e\u5ba1\u6838\u4eba\u5173\u7cfb"})
public class DictExamitemVerifyUserController {
    @Autowired
    private DictExamitemVerifyUserService dictExamitemVerifyUserService;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=DictExamitemVerifyUserDTO.class)
    @LogOperation(value="\u4fdd\u5b58", module="\u68c0\u67e5\u9879\u76ee\u4e0e\u5ba1\u6838\u4eba\u5173\u7cfb", operationType=1)
    public Result save(@RequestBody EncryptedReq<DictExamitemVerifyUserDTO> req) {
        DictExamitemVerifyUserDTO dto = (DictExamitemVerifyUserDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictExamitemVerifyUserService.save(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u68c0\u67e5\u9879\u76ee\u4e0e\u5ba1\u6838\u4eba\u5173\u7cfb", operationType=3)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictExamitemVerifyUserService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictExamitemVerifyUserParam.class)
    public Result getList(@RequestBody EncryptedReq<DictExamitemVerifyUserParam> req) {
        DictExamitemVerifyUserParam dto = (DictExamitemVerifyUserParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.dictExamitemVerifyUserService.getList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

