/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.bdform.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArchiveIdParam;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.HtmlUtils;
import io.huimu.common.utils.IDUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.LocalCacheUtil;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.utils.XmlUtils;
import io.huimu.modules.bdform.dao.BdFormDao;
import io.huimu.modules.bdform.dto.AddBdFormDTO;
import io.huimu.modules.bdform.dto.BdTemplateDTO;
import io.huimu.modules.bdform.dto.BdTemplateTypeDTO;
import io.huimu.modules.bdform.dto.CancelVerifyFormDTO;
import io.huimu.modules.bdform.dto.ChangeFormHcDTO;
import io.huimu.modules.bdform.dto.FormKeyValueDTO;
import io.huimu.modules.bdform.dto.GetLastWjdcDataJsonDTO;
import io.huimu.modules.bdform.dto.SaveFormDataDTO;
import io.huimu.modules.bdform.dto.VerifyFormDTO;
import io.huimu.modules.bdform.entity.BdFormEntity;
import io.huimu.modules.bdform.entity.BdReportVerifyLogEntity;
import io.huimu.modules.bdform.param.SendFormToWxParam;
import io.huimu.modules.bdform.param.SendWxOperaXzParam;
import io.huimu.modules.bdform.service.BdFormFileService;
import io.huimu.modules.bdform.service.BdFormService;
import io.huimu.modules.bdform.service.BdReportVerifyLogService;
import io.huimu.modules.bdform.service.impl.BdFormServiceImpl;
import io.huimu.modules.bdform.vo.BdFormDataVO;
import io.huimu.modules.bdform.vo.BdFormVO;
import io.huimu.modules.bdform.vo.BdSaveRecordVO;
import io.huimu.modules.bdform.vo.BdTemplateVo;
import io.huimu.modules.patient.service.PatientArchiveService;
import io.huimu.modules.register.entity.RegisterItemEntity;
import io.huimu.modules.register.service.ExamFilesService;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.service.UploadService;
import io.huimu.modules.websocket.WebSocketServer;
import io.huimu.modules.websocket.data.MessageData;
import io.huimu.modules.wx.service.WxService;
import io.huimu.modules.xj.entity.XjEntity;
import io.huimu.modules.xj.service.XjService;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BdFormServiceImpl
extends BaseServiceImpl<BdFormDao, BdFormEntity>
implements BdFormService {
    @Autowired
    private PatientArchiveService patientArchiveService;
    @Autowired
    private ExamFilesService examFilesService;
    @Autowired
    private BdReportVerifyLogService verifyLogService;
    @Autowired
    private SysUserDeptDataScopeService dataScopeService;
    @Autowired
    private WebSocketServer webSocketServer;
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private BdFormFileService bdFormFileService;
    @Value(value="${dataBaseType}")
    private String dataBaseType;
    @Autowired
    private WxService wxService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private XjService xjService;
    @Autowired
    private UploadService uploadService;

    public Result addForm(AddBdFormDTO dto) {
        BdTemplateDTO templateEntity;
        Integer count;
        if (StringUtils.isNotBlank((CharSequence)dto.getExamNo()) && (count = ((BdFormDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)dto.getExamNo())).eq((Object)"IS_DELETE", (Object)0)).lt((Object)"FORM_STATUS", (Object)20))) > 0) {
            return new Result().error("\u8be5\u68c0\u67e5\u9879\u76ee\u5df2\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8868\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u65b0\u589e");
        }
        String archiveId = dto.getArchiveId();
        if (StringUtils.isBlank((CharSequence)archiveId)) {
            archiveId = this.patientArchiveService.getPatientLastArchiveId(dto.getPatientId());
        }
        if (null == (templateEntity = ((BdFormDao)this.baseDao).getBdTemplateInfoById(dto.getTemplateCode()))) {
            return new Result().error("\u8868\u5355\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        BdFormEntity entity = new BdFormEntity();
        entity.setTemplateCode(dto.getTemplateCode());
        entity.setCreateDate(new Date());
        entity.setFormDate(dto.getFormDate());
        entity.setPatientId(dto.getPatientId());
        entity.setIsSave(Integer.valueOf(0));
        entity.setIsDelete(Integer.valueOf(0));
        entity.setArchiveId(archiveId);
        entity.setDeptCode(dto.getDeptCode());
        entity.setOrgCode(dto.getOrgCode());
        entity.setJzNumber(dto.getJzNumber());
        entity.setCreateUserCode(dto.getCreateUserCode());
        entity.setFormName(dto.getFormName());
        entity.setExamNo(dto.getExamNo());
        entity.setPatientIdNumber(dto.getPatientIdNumber());
        this.insert((Object)entity);
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delForm(String id) {
        BdFormVO formVO = ((BdFormDao)this.baseDao).getInfoById(id);
        if (null == formVO) {
            return new Result().error("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsLock() && !SecurityUser.getEmployeeId().equals(formVO.getLockUserCode())) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getLockUserName() + "]\u9501\u5b9a");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tableName", formVO.getBindTableName());
        param.put("formId", id);
        param.put("delUserCode", SecurityUser.getEmployeeId());
        param.put("delUserName", SecurityUser.getUser().getRealName());
        ((BdFormDao)this.baseDao).callDelForm(param);
        Integer result = (Integer)param.get("result");
        if (null == result || result == 0) {
            throw new RenException("\u5220\u9664\u5931\u8d25");
        }
        BdFormEntity updateEntity = new BdFormEntity();
        updateEntity.setId(id);
        updateEntity.setIsDelete(Integer.valueOf(1));
        updateEntity.setDelDate(new Date());
        updateEntity.setDelUserCode(SecurityUser.getEmployeeId());
        updateEntity.setDelUserName(SecurityUser.getUser().getRealName());
        ((BdFormDao)this.baseDao).updateById((Object)updateEntity);
        this.bdFormFileService.deleteByFormId(id);
        if (formVO.getTemplateCode().startsWith("BGMB") && StringUtils.isNotBlank((CharSequence)formVO.getExamNo())) {
            int existCount = ((BdFormDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)formVO.getExamNo())).eq((Object)"IS_DELETE", (Object)0));
            this.examFilesService.deleteByFormId(id, formVO.getExamNo(), existCount);
        }
        return new Result();
    }

    public BdFormDataVO getFormData(String patientId, String formId, String orgCode) throws InterruptedException {
        BdFormVO formVO = ((BdFormDao)this.baseDao).getInfoById(formId);
        if (null == formVO) {
            throw new RenException("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsDelete()) {
            throw new RenException("\u8868\u5355\u5df2\u88ab[" + formVO.getDelUserName() + "]\u5220\u9664");
        }
        BdFormDataVO formDataVO = new BdFormDataVO();
        formDataVO.setFilePath(formVO.getPdfPath());
        formDataVO.setSaveNum(formVO.getSaveNum());
        formDataVO.setIsSave(formVO.getIsSave());
        formDataVO.setExamNo(formVO.getExamNo());
        formDataVO.setFormStatus(formVO.getFormStatus());
        formDataVO.setSaveUserName(formVO.getSaveUserName());
        formDataVO.setSaveDate(formVO.getSaveDate());
        formDataVO.setIsLock(formVO.getIsLock());
        formDataVO.setLockUserCode(formVO.getLockUserCode());
        formDataVO.setLockUserName(formVO.getLockUserName());
        if (!StringUtils.isNotBlank((CharSequence)formVO.getFtpPath()) || !StringUtils.isNotBlank((CharSequence)formVO.getHtmlPath())) {
            throw new RenException("\u914d\u7f6e\u4fe1\u606f\u7f3a\u5c11FTP\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        formDataVO.setContent(FileUtils.getFileContent((String)formVO.getHtmlPath(), (String)formVO.getFtpPath()));
        if (formVO.getIsSave() == 0) {
            if (formVO.getTemplateCode().startsWith("BGMB")) {
                Map dataMap;
                HashMap resMap = new HashMap();
                if (StringUtils.isNotBlank((CharSequence)formVO.getExamNo()) && !CollectionUtils.isEmpty((Map)(dataMap = ((BdFormDao)this.baseDao).getReportFormData(formVO.getExamNo())))) {
                    resMap.putAll(dataMap);
                }
                if (StringUtils.isNotBlank((CharSequence)formVO.getSelectViewName())) {
                    String[] viewArray;
                    for (String viewName2 : viewArray = formVO.getSelectViewName().split(",")) {
                        Map map;
                        if (!viewName2.startsWith("VIEW_DOCTOR_") || CollectionUtils.isEmpty((Map)(map = ((BdFormDao)this.baseDao).selectDoctorInfo(viewName2, SecurityUser.getEmployeeId())))) continue;
                        resMap.putAll(map);
                    }
                }
                formDataVO.setDataMap((Map)MapUtils.mapKeyUpperCaseObject(resMap));
            } else if (StringUtils.isNotBlank((CharSequence)formVO.getSelectViewName())) {
                List<String> viewArray = Arrays.asList(formVO.getSelectViewName().split(","));
                HashMap resMap = new HashMap();
                List<CompletableFuture> futures = viewArray.stream().map(viewName -> CompletableFuture.supplyAsync(() -> this.handleData(viewName, patientId, orgCode))).collect(Collectors.toList());
                CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                allFutures.join();
                List results = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
                for (Map map : results) {
                    if (CollectionUtils.isEmpty((Map)map)) continue;
                    resMap.putAll(map);
                }
                formDataVO.setDataMap((Map)MapUtils.mapKeyUpperCaseObject(resMap));
            }
        }
        return formDataVO;
    }

    public Map<String, Object> handleData(String viewName, String patientId, String orgCode) {
        if (viewName.startsWith("VIEW_DOCTOR_")) {
            return ((BdFormDao)this.baseDao).selectDoctorInfo(viewName, SecurityUser.getEmployeeId());
        }
        return ((BdFormDao)this.baseDao).selectViewData(viewName, patientId, orgCode);
    }

    public List getFormList(ArchiveIdParam param) {
        if (StringUtils.isNotBlank((CharSequence)param.getPatientId())) {
            BdFormEntity entity = new BdFormEntity();
            entity.setPatientId(param.getPatientId());
            entity.setJzNumber(param.getJzNumber());
            ((BdFormDao)this.baseDao).update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ARCHIVE_ID", (Object)param.getArchiveId())).isNull((Object)"PATIENT_ID"));
        }
        ArrayList resList = new ArrayList();
        List formList = ((BdFormDao)this.baseDao).getFormList(param);
        List typeList = ((BdFormDao)this.baseDao).getTemplateTypeList();
        for (BdTemplateTypeDTO type : typeList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List tempList = formList.stream().filter(info -> info.getTypeCode().equalsIgnoreCase(type.getTypeCode())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(tempList)) continue;
            tempList.sort(Comparator.comparing(BdFormVO::getFormDate, Comparator.reverseOrder()).thenComparing(BdFormVO::getCreateDate, Comparator.reverseOrder()));
            map.put("typeName", type.getName());
            map.put("list", tempList);
            resList.add(map);
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result saveFormData(SaveFormDataDTO dto) throws IOException {
        BdFormVO formVO = ((BdFormDao)this.baseDao).getInfoById(dto.getFormId());
        if (null == formVO) {
            return new Result().error("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsDelete()) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getDelUserName() + "]\u5220\u9664");
        }
        if (formVO.getIsSave() == 3 && !formVO.getSaveUserCode().equalsIgnoreCase(SecurityUser.getEmployeeId())) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getSaveUserName() + "]\u6682\u5b58\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4fdd\u5b58");
        }
        Integer itemPushFlag = this.registerItemService.getItemPushFlagByExamNo(formVO.getExamNo());
        if (formVO.getFormStatus() == 20 && null != itemPushFlag && itemPushFlag == 3) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getVerifyReportUserName() + "]\u5ba1\u6838\u5b8c\u6bd5\uff0c\u65e0\u6cd5\u518d\u6b21\u4fdd\u5b58");
        }
        if (StringUtils.isNotBlank((CharSequence)LocalCacheUtil.get((String)dto.getFormId())) && SecurityUser.getEmployeeId().equals(LocalCacheUtil.get((String)dto.getFormId()))) {
            return new Result().error("\u8868\u5355\u5df2\u88ab\u5f3a\u5236\u89e3\u9501\uff0c\u5982\u9700\u518d\u6b21\u7f16\u8f91\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u67e5\u770b\u6b64\u8868\u5355\u662f\u5426\u5904\u4e8e\u5176\u4ed6\u533b\u751f\u7f16\u8f91\u9501\u5b9a\u72b6\u6001\uff01");
        }
        if (1 == formVO.getIsLock() && !SecurityUser.getEmployeeId().equals(formVO.getLockUserCode())) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getLockUserName() + "]\u9501\u5b9a");
        }
        UploadEntity jsonDataFileDTO = FileUtils.writeToFile((String)JsonUtils.toJsonString((Object)dto.getDataList()), (String)formVO.getFtpPath(), (String)("jsonData/" + formVO.getPatientId()), null, (String)"txt");
        UploadEntity xmlDataFileDTO = FileUtils.writeToFile((String)XmlUtils.createXmlString((List)dto.getDataList()), (String)formVO.getFtpPath(), (String)("xmlData/" + formVO.getPatientId()), null, (String)"txt");
        ((BdFormDao)this.baseDao).deleteFormData(formVO.getBindTableName(), dto.getFormId());
        List dataList = dto.getDataList();
        String dataRecordId = null;
        if (CollUtil.isNotEmpty((Collection)dataList)) {
            dataRecordId = IDUtils.generateStringValue();
            1 fieldList = new /* Unavailable Anonymous Inner Class!! */;
            StringBuffer fieldBuffer = new StringBuffer();
            StringBuffer valueBuffer = new StringBuffer();
            fieldBuffer.append("ID,FORM_ID,IS_DELETE,CREATE_DATE,SAVE_USER_CODE,SAVE_USER_NAME,SAVE_DATE,HTML_PATH,PDF_PATH,IS_CA,CA_PDF_PATH,JSON_DATA_FILE_PATH,XML_DATA_FILE_PATH,ORG_CODE,DEPT_CODE ");
            valueBuffer.append("'").append(dataRecordId).append("', ").append("'").append(dto.getFormId()).append("', ").append(0).append(", ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append("'").append(SecurityUser.getEmployeeId()).append("', ").append("'").append(SecurityUser.getUser().getRealName()).append("', ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append(StringUtils.isBlank((CharSequence)dto.getHtmlPath()) ? null + "," : "'" + dto.getHtmlPath() + "', ").append(StringUtils.isBlank((CharSequence)dto.getPdfPath()) ? null + "," : "'" + dto.getPdfPath() + "', ").append("0,").append(StringUtils.isBlank((CharSequence)dto.getCaPdfPath()) ? null + "," : "'" + dto.getCaPdfPath() + "', ").append(StringUtils.isBlank((CharSequence)jsonDataFileDTO.getFilePath()) ? null + "," : "'" + jsonDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)xmlDataFileDTO.getFilePath()) ? null + "," : "'" + xmlDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)dto.getOrgCode()) ? null + "," : "'" + dto.getOrgCode() + "', ").append(StringUtils.isBlank((CharSequence)dto.getDeptCode()) ? null + "," : "'" + dto.getDeptCode() + "' ");
            for (FormKeyValueDTO valueDTO : dataList) {
                if (valueDTO.getKey().startsWith("SIGN") || valueDTO.getKey().startsWith("EIMG") || valueDTO.getKey().startsWith("IIMG") || fieldList.contains(valueDTO.getKey())) continue;
                fieldBuffer.append(",").append(valueDTO.getKey());
                valueBuffer.append(StringUtils.isBlank((CharSequence)valueDTO.getValue()) ? "," + null : ",'" + valueDTO.getValue() + "'");
                fieldList.add(valueDTO.getKey());
            }
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("insert into ").append(formVO.getBindTableName()).append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
            ((BdFormDao)this.baseDao).saveFormData(sqlBuffer);
            StringBuffer recordSqlBuffer = new StringBuffer();
            recordSqlBuffer.append("insert into ").append(formVO.getBindTableName()).append("_RECORD").append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
            ((BdFormDao)this.baseDao).saveFormData(recordSqlBuffer);
        }
        BdFormEntity entity = new BdFormEntity();
        entity.setId(dto.getFormId());
        entity.setIsSave(dto.getIsSave());
        entity.setSaveDate(new Date());
        entity.setFormDataRecordId(dataRecordId);
        entity.setIsLock(Integer.valueOf(0));
        entity.setLockUserCode("");
        entity.setLockUserName("");
        entity.setSaveUserCode(SecurityUser.getEmployeeId());
        entity.setSaveUserName(SecurityUser.getUser().getRealName());
        entity.setHtmlPath(dto.getHtmlPath());
        entity.setPdfPath(dto.getPdfPath());
        entity.setIsCa(Integer.valueOf(0));
        entity.setCaPdfPath(dto.getCaPdfPath());
        entity.setJsonDataFilePath(jsonDataFileDTO.getFilePath());
        entity.setXmlDataFilePath(jsonDataFileDTO.getFilePath());
        entity.setOrgCode(dto.getOrgCode());
        entity.setDeptCode(dto.getDeptCode());
        entity.setSaveNum(Integer.valueOf(formVO.getSaveNum() + 1));
        if (null != itemPushFlag) {
            if (itemPushFlag == 3 || dto.getIsSave() == 3) {
                entity.setFormStatus(Integer.valueOf(10));
            } else {
                entity.setFormStatus(Integer.valueOf(20));
                entity.setVerifyReportUserCode(SecurityUser.getEmployeeId());
                entity.setVerifyReportUserName(SecurityUser.getUser().getRealName());
                entity.setVerifyReportTime(new Date());
            }
        } else {
            entity.setFormStatus(Integer.valueOf(10));
        }
        entity.setEditReportUserName(SecurityUser.getUser().getRealName());
        entity.setEditReportUserCode(SecurityUser.getEmployeeId());
        entity.setEditReportTime(new Date());
        if (formVO.getFormStatus() == 15) {
            ((BdFormDao)this.baseDao).resetVerifyFormStatus(dto.getFormId());
        }
        ((BdFormDao)this.baseDao).updateById((Object)entity);
        if (dto.getIsSave() == 5 && formVO.getTemplateCode().startsWith("BGMB") && StringUtils.isNotBlank((CharSequence)formVO.getExamNo())) {
            this.examFilesService.uploadSecondFiles(dto.getOrgCode(), dto.getDeptCode(), dto.getPdfFilePath(), dto.getPdfFileName(), formVO.getExamNo(), dto.getDeviceId(), dto.getFormId(), itemPushFlag);
        }
        return new Result();
    }

    public Integer getCountByArchiveId(String archiveId) {
        return ((BdFormDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ARCHIVE_ID", (Object)archiveId)).eq((Object)"IS_DELETE", (Object)0));
    }

    public List<BdSaveRecordVO> getFormSaveRecordList(String formId) {
        BdFormEntity formEntity = (BdFormEntity)((BdFormDao)this.baseDao).selectById((Serializable)((Object)formId));
        BdTemplateDTO templateDTO = ((BdFormDao)this.baseDao).getBdTemplateInfoById(formEntity.getTemplateCode());
        return ((BdFormDao)this.baseDao).getFormSaveRecordList(formId, templateDTO.getBindTableName() + "_RECORD");
    }

    public String getFormSaveRecordData(String id, String formId) {
        BdFormEntity formEntity = (BdFormEntity)((BdFormDao)this.baseDao).selectById((Serializable)((Object)formId));
        BdTemplateDTO templateDTO = ((BdFormDao)this.baseDao).getBdTemplateInfoById(formEntity.getTemplateCode());
        String filePath = ((BdFormDao)this.baseDao).getFormSaveRecordFile(id, templateDTO.getBindTableName() + "_RECORD");
        return FileUtils.getFileContent((String)filePath, (String)templateDTO.getFtpPath());
    }

    public Map<String, List<BdTemplateDTO>> getListByMenuId(String menuId, String orgCode) {
        HashMap<String, List<BdTemplateDTO>> resMap = new HashMap<String, List<BdTemplateDTO>>();
        List tempCodeList = ((BdFormDao)this.baseDao).getTemplateIdListByMenuId(menuId, orgCode);
        if (CollUtil.isNotEmpty((Collection)tempCodeList)) {
            List tempList = ((BdFormDao)this.baseDao).selectTemplateList(tempCodeList);
            List typeList = ((BdFormDao)this.baseDao).getTemplateTypeList();
            for (BdTemplateTypeDTO type : typeList) {
                List bdList = tempList.stream().filter(info -> info.getTypeCode().equalsIgnoreCase(type.getTypeCode())).collect(Collectors.toList());
                if (!CollUtil.isNotEmpty(bdList)) continue;
                bdList.sort(Comparator.comparing(BdTemplateDTO::getSortIndex, Comparator.naturalOrder()));
                resMap.put(type.getName(), ConvertUtils.sourceToTarget(bdList, BdTemplateDTO.class));
            }
        }
        return resMap;
    }

    public List<BdTemplateDTO> getNoTypeListByMenuId() {
        return ((BdFormDao)this.baseDao).getNoTypeListByMenuId();
    }

    public List<BdTemplateVo> getTableTemplate(String templateCode, String typeCode) {
        List list = ((BdFormDao)this.baseDao).getTableTemplate(templateCode, typeCode);
        return list;
    }

    public Result lockTable(String id) {
        BdFormEntity bdFormEntity = (BdFormEntity)((BdFormDao)this.baseDao).selectById((Serializable)((Object)id));
        if (bdFormEntity == null) {
            return new Result().error("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        if (bdFormEntity.getIsLock() == 1 && !SecurityUser.getEmployeeId().equals(bdFormEntity.getLockUserCode())) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + bdFormEntity.getLockUserName() + "]\u9501\u5b9a");
        }
        if (StringUtils.isNotBlank((CharSequence)LocalCacheUtil.get((String)id)) && SecurityUser.getEmployeeId().equals(LocalCacheUtil.get((String)id))) {
            LocalCacheUtil.remove((String)id);
        }
        bdFormEntity.setIsLock(Integer.valueOf(1));
        bdFormEntity.setLockUserCode(SecurityUser.getEmployeeId());
        bdFormEntity.setLockUserName(SecurityUser.getUser().getRealName());
        ((BdFormDao)this.baseDao).updateById((Object)bdFormEntity);
        return new Result();
    }

    public Result unlockTable(String id) {
        BdFormEntity bdFormEntity = (BdFormEntity)((BdFormDao)this.baseDao).selectById((Serializable)((Object)id));
        if (bdFormEntity == null || bdFormEntity.getIsDelete() == 1) {
            return new Result().error("\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        if (!SecurityUser.getEmployeeId().equals(bdFormEntity.getLockUserCode())) {
            Integer flag = ((BdFormDao)this.baseDao).getUnlockAuthority(SecurityUser.getEmployeeId());
            if (flag == null || flag != 1) {
                return new Result().error("\u6ca1\u6709\u6743\u9650");
            }
            LocalCacheUtil.put((String)id, (String)bdFormEntity.getLockUserCode(), (long)86400L);
        }
        bdFormEntity.setIsLock(Integer.valueOf(0));
        bdFormEntity.setLockUserName("");
        bdFormEntity.setLockUserCode("");
        ((BdFormDao)this.baseDao).updateById((Object)bdFormEntity);
        return new Result();
    }

    public void updateFormFileContent(String formId, Map<String, String> dataMap) throws UnsupportedEncodingException {
        BdFormVO formVO;
        if (null != dataMap && null != (formVO = ((BdFormDao)this.baseDao).getInfoById(formId)) && formVO.getIsDelete() == 0 && formVO.getIsSave() > 0) {
            String str = FileUtils.getFileContent((String)formVO.getJsonDataFilePath(), (String)formVO.getFtpPath());
            List dtoList = JSONArray.parseArray((String)str, FormKeyValueDTO.class);
            if (CollUtil.isNotEmpty((Collection)dtoList)) {
                for (String key : dataMap.keySet()) {
                    Optional<FormKeyValueDTO> valueDTO = dtoList.stream().filter(f -> f.getKey().equals(key)).findFirst();
                    if (!valueDTO.isPresent()) continue;
                    FormKeyValueDTO keyValueDTO = valueDTO.get();
                    keyValueDTO.setValue(dataMap.get(key));
                }
            }
            FileUtils.reWriteTxtContent((String)formVO.getFtpPath(), (String)formVO.getJsonDataFilePath(), (String)JsonUtils.toJsonString((Object)dtoList));
            FileUtils.reWriteTxtContent((String)formVO.getFtpPath(), (String)formVO.getXmlDataFilePath(), (String)XmlUtils.createXmlString((List)dtoList));
            String htmlStr = FileUtils.getFileContent((String)formVO.getHtmlPath(), (String)formVO.getFtpPath());
            String newStr = HtmlUtils.replaceValueByIds((String)URLDecoder.decode(htmlStr, "UTF-8"), dataMap);
            FileUtils.reWriteTxtContent((String)formVO.getFtpPath(), (String)formVO.getHtmlPath(), (String)URLEncoder.encode(newStr, "UTF-8"));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Result verifyForm(VerifyFormDTO dto) {
        RegisterItemEntity itemInfoVO;
        BdFormVO formVO = ((BdFormDao)this.baseDao).getInfoById(dto.getFormId());
        if (null == formVO) {
            return new Result().error("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsDelete()) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getDelUserName() + "]\u5220\u9664");
        }
        Integer itemPushFlag = this.registerItemService.getItemPushFlagByExamNo(formVO.getExamNo());
        if (formVO.getFormStatus() == 20 && null != itemPushFlag && itemPushFlag == 3) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getVerifyReportUserName() + "]\u5ba1\u6838\u5b8c\u6bd5\uff0c\u65e0\u6cd5\u518d\u6b21\u5ba1\u6838");
        }
        BdFormEntity entity = new BdFormEntity();
        entity.setFormStatus(dto.getVerifyFlag());
        entity.setVerifyReportTime(new Date());
        entity.setVerifyReportUserCode(SecurityUser.getEmployeeId());
        entity.setVerifyReportUserName(SecurityUser.getUser().getRealName());
        entity.setVerifyMsg(dto.getVerifyMsg());
        entity.setId(dto.getFormId());
        this.updateById((Object)entity);
        if (StringUtils.isNotBlank((CharSequence)formVO.getExamNo())) {
            this.examFilesService.verifyReport(Integer.valueOf(1), dto.getVerifyFlag(), dto.getFormId(), dto.getVerifyMsg(), dto.getDeptCode(), dto.getOrgCode());
        }
        BdReportVerifyLogEntity verifyLogEntity = new BdReportVerifyLogEntity();
        verifyLogEntity.setExamNo(formVO.getExamNo());
        verifyLogEntity.setFormId(formVO.getId());
        verifyLogEntity.setVerifyFlag(dto.getVerifyFlag());
        verifyLogEntity.setVerifyMsg(dto.getVerifyMsg());
        verifyLogEntity.setVerifyUserCode(SecurityUser.getEmployeeId());
        verifyLogEntity.setVerifyUserName(SecurityUser.getUser().getRealName());
        verifyLogEntity.setVerifyTime(new Date());
        this.verifyLogService.insert((Object)verifyLogEntity);
        if (StringUtils.isNotBlank((CharSequence)formVO.getExamNo()) && null != (itemInfoVO = this.registerItemService.selectInfoByExamNo(formVO.getExamNo()))) {
            MessageData messageData = new MessageData();
            messageData.setData((Object)itemInfoVO);
            messageData.setType(1);
            this.webSocketServer.sendMessage(dto.getDeviceId(), (Object)messageData);
        }
        return new Result();
    }

    public Result cancelVerifyForm(CancelVerifyFormDTO dto) {
        RegisterItemEntity itemInfoVO;
        BdFormVO formVO = ((BdFormDao)this.baseDao).getInfoById(dto.getFormId());
        if (null == formVO) {
            return new Result().error("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsDelete()) {
            return new Result().error("\u8868\u5355\u5df2\u88ab[" + formVO.getDelUserName() + "]\u5220\u9664");
        }
        BdFormEntity entity = new BdFormEntity();
        entity.setFormStatus(Integer.valueOf(10));
        entity.setVerifyReportTime(null);
        entity.setVerifyReportUserCode(null);
        entity.setVerifyReportUserName(null);
        entity.setVerifyMsg(null);
        entity.setId(dto.getFormId());
        this.updateById((Object)entity);
        if (StringUtils.isNotBlank((CharSequence)formVO.getExamNo())) {
            this.examFilesService.cancelVerifyForm(dto.getFormId());
        }
        BdReportVerifyLogEntity verifyLogEntity = new BdReportVerifyLogEntity();
        verifyLogEntity.setExamNo(formVO.getExamNo());
        verifyLogEntity.setFormId(formVO.getId());
        verifyLogEntity.setVerifyFlag(Integer.valueOf(30));
        verifyLogEntity.setVerifyMsg(dto.getVerifyMsg());
        verifyLogEntity.setVerifyUserCode(SecurityUser.getEmployeeId());
        verifyLogEntity.setVerifyUserName(SecurityUser.getUser().getRealName());
        verifyLogEntity.setVerifyTime(new Date());
        this.verifyLogService.insert((Object)verifyLogEntity);
        if (StringUtils.isNotBlank((CharSequence)formVO.getExamNo()) && null != (itemInfoVO = this.registerItemService.selectInfoByExamNo(formVO.getExamNo()))) {
            MessageData messageData = new MessageData();
            messageData.setData((Object)itemInfoVO);
            messageData.setType(1);
            this.webSocketServer.sendMessage(dto.getDeviceId(), (Object)messageData);
        }
        return new Result();
    }

    public PageData<BdFormVO> getVerifyFormPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        String page = (String)params.get("page");
        String limit = (String)params.get("limit");
        PageHelper.startPage((int)Integer.parseInt(page), (int)Integer.parseInt(limit));
        List list = ((BdFormDao)this.baseDao).getVerifyFormList(params);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), BdFormVO.class);
    }

    public Map<String, Object> getBdExamInfo(String examNo) {
        Map resMap = ((BdFormDao)this.baseDao).getBdExamInfo(examNo);
        return MapUtils.mapKeyUpperCaseObject((Map)resMap);
    }

    public BdTemplateDTO getTemplateInfo(String templateCode) {
        return ((BdFormDao)this.baseDao).getTemplateInfo(templateCode);
    }

    public BdFormVO getFormInfoById(String fromId) {
        return ((BdFormDao)this.baseDao).getFormInfoById(fromId);
    }

    public void sendWxOperaXz(SendWxOperaXzParam data) {
        List xjEntityList = this.xjService.getListByNodeAndTitle("\u672f\u524d\u5ba3\u6559", "\u60a3\u8005\u987b\u77e5");
        if (CollUtil.isEmpty((Collection)xjEntityList)) {
            throw new RenException("\u5ba3\u6559\u63a8\u9001\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String wxTemplateId = this.sysSystemConfService.getConfValue("100044", null);
        if (StringUtils.isBlank((CharSequence)wxTemplateId)) {
            throw new RenException("\u5fae\u4fe1\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map wxParamMap = this.wxService.getSendWxMsgParam(data.getOrgName(), data.getPatientName(), "\u8bf7\u70b9\u51fb\u8be6\u60c5\uff0c\u4ed4\u7ec6\u9605\u8bfb\u624b\u672f\u987b\u77e5\u5185\u5bb9");
        for (XjEntity entity : xjEntityList) {
            this.wxService.sendMessage(wxTemplateId, wxParamMap, data.getPatientIdNumber(), entity.getUrl() + data.getFormId(), Integer.valueOf(10), entity.getTitle(), entity.getXjName());
        }
    }

    public void sendFormToWx(SendFormToWxParam data) {
        String wxTemplateId = this.sysSystemConfService.getConfValue("100044", null);
        if (StringUtils.isBlank((CharSequence)wxTemplateId)) {
            throw new RenException("\u5fae\u4fe1\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String sendUrl = this.sysSystemConfService.getConfValue("100047", null);
        if (StringUtils.isBlank((CharSequence)sendUrl)) {
            throw new RenException("\u53d1\u9001\u8868\u5355\u81f3\u5fae\u4fe1URL\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map wxParamMap = this.wxService.getSendWxMsgParam(data.getOrgName(), data.getPatientName(), data.getRemark());
        this.wxService.sendMessage(wxTemplateId, wxParamMap, data.getPatientIdNumber(), sendUrl + "?formId=" + data.getFormId() + "&patientId=" + data.getPatientId() + "&formName=" + data.getFormName(), Integer.valueOf(60), "\u60a3\u8005\u8868\u5355", data.getFormName());
    }

    public void changeFormHc(ChangeFormHcDTO data) {
        BdFormEntity entity = new BdFormEntity();
        entity.setId(data.getFormId());
        entity.setIsHc(data.getIsHc());
        this.updateById((Object)entity);
    }

    public String getLastWjdcDataJson(GetLastWjdcDataJsonDTO data) {
        String jsonPath = ((BdFormDao)this.baseDao).getLastWjdcDataJson(data.getPatientId());
        return this.uploadService.getFileContent(jsonPath);
    }
}

