/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.batchdown.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.StopWatch;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.ZipUtils;
import io.huimu.modules.batchdown.config.DownLoadThread;
import io.huimu.modules.batchdown.config.ExecutorConfig;
import io.huimu.modules.batchdown.dao.BatchDownloadDao;
import io.huimu.modules.batchdown.vo.PatientExamFilesVO;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchDownloadService {
    @Autowired
    private ExecutorConfig executorConfig;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private BatchDownloadDao downloadDao;

    public String returnZipPath(List<String> patientIds) {
        List filesVO = this.downloadDao.getDownFileList(patientIds);
        if (CollUtil.isNotEmpty((Collection)filesVO)) {
            String parentPath = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            String todayStr = DateUtils.format((Date)new Date());
            Map<String, List<PatientExamFilesVO>> map = filesVO.stream().collect(Collectors.groupingBy(PatientExamFilesVO::getPatientName));
            String zipPath = this.sysSystemConfService.getConfValue("100022", "");
            String downTempFilePath = zipPath + "/" + todayStr + "/" + parentPath;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            File file = new File(downTempFilePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                Executor executor = this.executorConfig.asyncServiceExecutor();
                CountDownLatch countDownLatch = new CountDownLatch(map.size());
                for (String key : map.keySet()) {
                    List<PatientExamFilesVO> filesVOList = map.get(key);
                    executor.execute((Runnable)new DownLoadThread(countDownLatch, downTempFilePath + "/" + key + "/", filesVOList));
                }
                countDownLatch.await();
                stopWatch.stop();
                System.out.println("\u4e0b\u8f7d\u5171\u8017\u65f6\uff1a" + stopWatch.getTotalTimeSeconds() + "\u79d2");
                String zipName = parentPath + ".zip";
                ZipUtils.toZip((String)downTempFilePath, (String)(zipPath + "/" + todayStr + "/" + zipName), (boolean)true);
                String string = todayStr + "/" + zipName;
                return string;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    FileUtils.deleteDir((String)downTempFilePath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new RenException("\u672a\u67e5\u8be2\u5230\u6587\u4ef6\u6570\u636e");
    }
}

