/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.datatype.CX;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.PipeParser;

public class HL7Utils {
    public static String parseHL7Message(String hl7Message) throws HL7Exception {
        DefaultHapiContext context = new DefaultHapiContext();
        PipeParser parser = context.getPipeParser();
        hl7Message = "MSH|^~\\&|HIS_InPatient|WinningSoft|TECH|WinningSoft|20191015094407|pv1|ADT^A01|2323B725-8034-4182-926F-2972CF2C2D55|P|2.4|||||CHN\nEVN|A01|20191015094407\nPID|1|53271^^^&PATID|53271^^^&PATID~19037084^^^&BLH~1001280474^^^&BRKH^2~320722195903102061^^^&SFZH~0^^^&YEXH||\u845b\u7fe0\u5e73||19590310000000|F||||||||D^\u5df2\u5a5a||||||01^\u6c49\u65cf||||||156^\u4e2d\u56fd\nPV1|1|I|10400103^\u80c3\u80a0\u5916\u79d1\u897f^^^^^11106^\u516d\u75c5\u533a||||||||||||||||53422|2111~\u9000\u4f11\u4f4f\u9662\u533b\u4fdd||||||||||||||||||||0||||20191015094400||||||53422\nPV2||||||||||||||||||||||||||||||||||||N\nDG1|||I84.201^\u6df7\u5408\u75d4|||0|0\nDG1|||K60.200^\u809b\u88c2|||1|0";
        try {
            Structure[] dg1Structures;
            Message message = parser.parse(hl7Message.replace("\\x0b", "").replace("\n", "\r\n").replace("\u001c", ""));
            PID patient = (PID)message.get("PID");
            if (null != patient) {
                System.out.println("PID" + patient.getSetIDPID() + "patient id:" + patient.getPatientID());
            }
            System.out.println("-----------------------------");
            CX[] cxes = patient.getPatientIdentifierList();
            System.out.println("PATID\uff1a" + cxes[0].getID().getVersion());
            System.out.println("BLH\uff1a" + cxes[1].getID().getVersion());
            System.out.println("BRKH\uff1a" + cxes[2].getID().getVersion());
            System.out.println("SFZH\uff1a" + cxes[3].getID().getVersion());
            System.out.println("YEXH\uff1a" + cxes[4].getID().getVersion());
            System.out.println("-----------------------------");
            for (Structure structure : dg1Structures = message.getAll("DG1")) {
                DG1 dg1 = (DG1)structure;
                String setId = dg1.getSetIDDG1().getValue();
                String diagnosisCode = dg1.getDiagnosisCodeDG1().getIdentifier().getValue();
                String diagnosisDescription = dg1.getDiagnosisCodeDG1().getText().getValue();
                String diagnosisType = dg1.getDiagnosisType().getValue();
                System.out.println("DG1 Set ID: " + setId);
                System.out.println("Diagnosis Code: " + diagnosisCode);
                System.out.println("Diagnosis Description: " + diagnosisDescription);
                System.out.println("Diagnosis Type: " + diagnosisType);
                System.out.println("-----------------------------");
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error parsing HL7 message: " + e.getMessage());
            return null;
        }
    }
}

