/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;

public class DynamicColumnWidthStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private static final int BASE_WIDTH = 256;
    private static final int HEAD_EXTRA_WIDTH = 2;
    private static final int CONTENT_EXTRA_WIDTH = 1;

    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue()) {
            String headValue = cell.getStringCellValue();
            int width = (headValue.length() + 2) * 256;
            this.setColumnWidth(writeSheetHolder, cell.getColumnIndex(), width);
        } else if (cellDataList != null && !cellDataList.isEmpty()) {
            CellData cellData = cellDataList.get(0);
            int contentLength = this.getContentLength(cellData);
            int width = (contentLength + 1) * 256;
            this.setColumnWidth(writeSheetHolder, cell.getColumnIndex(), width);
        }
    }

    private int getContentLength(CellData cellData) {
        if (cellData == null) {
            return 0;
        }
        CellDataTypeEnum type = cellData.getType();
        if (type == CellDataTypeEnum.STRING) {
            return cellData.getStringValue() != null ? cellData.getStringValue().length() : 0;
        }
        if (type == CellDataTypeEnum.NUMBER) {
            return cellData.getNumberValue().toString().length();
        }
        return 0;
    }

    private void setColumnWidth(WriteSheetHolder writeSheetHolder, int columnIndex, int width) {
        int maxWidth = 15360;
        int minWidth = 2560;
        width = Math.min(width, maxWidth);
        width = Math.max(width, minWidth);
        if (writeSheetHolder.getSheet().getColumnWidth(columnIndex) < width) {
            writeSheetHolder.getSheet().setColumnWidth(columnIndex, width);
        }
    }
}

