/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.dict.service.DictStandardKnowService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dao.SysKnowledgeDao;
import io.huimu.modules.sys.dto.SysKnowledgeDTO;
import io.huimu.modules.sys.entity.SysKnowledgeEntity;
import io.huimu.modules.sys.service.SysKnowledgeService;
import io.huimu.modules.sys.vo.SysKnowledgeVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysKnowledgeServiceImpl
extends BaseServiceImpl<SysKnowledgeDao, SysKnowledgeEntity>
implements SysKnowledgeService {
    @Autowired
    private DictStandardKnowService standardKnowService;

    public void saveKnow(SysKnowledgeDTO dto) {
        SysKnowledgeEntity entity = (SysKnowledgeEntity)ConvertUtils.sourceToTarget((Object)dto, SysKnowledgeEntity.class);
        entity.setCreateUserCode(SecurityUser.getEmployeeId());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        this.insert((Object)entity);
    }

    public void updateKnow(SysKnowledgeDTO dto) {
        SysKnowledgeEntity entity = (SysKnowledgeEntity)ConvertUtils.sourceToTarget((Object)dto, SysKnowledgeEntity.class);
        entity.setCreateUserCode(SecurityUser.getEmployeeId());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        this.updateById((Object)entity);
    }

    public PageData<SysKnowledgeDTO> getKnowPage(Map<String, Object> param) {
        String page = (String)param.get("page");
        String limit = (String)param.get("limit");
        PageHelper.startPage((int)Integer.parseInt(page), (int)Integer.parseInt(limit));
        List list = ((SysKnowledgeDao)this.baseDao).getKnowPage(param);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), SysKnowledgeDTO.class);
    }

    public List<SysKnowledgeVO> getKnowList(Map<String, Object> params) {
        Integer knowType = (Integer)params.get("knowType");
        List list = ((SysKnowledgeDao)this.baseDao).selectList((Wrapper)new QueryWrapper().eq(null != knowType, (Object)"KNOW_TYPE", (Object)knowType));
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, SysKnowledgeVO.class));
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDelKnow(List<String> ids) {
        Integer count = ((SysKnowledgeDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().in((Object)"PID", ids));
        if (count > 0) {
            throw new RenException("\u5220\u9664\u9879\u4e2d\u5305\u542b\u5b50\u96c6\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.standardKnowService.deleteByKnowIds(ids);
        ((SysKnowledgeDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"ID", ids));
    }

    public SysKnowledgeDTO getKnowInfo(String id) {
        SysKnowledgeEntity entity = (SysKnowledgeEntity)((SysKnowledgeDao)this.baseDao).selectById((Serializable)((Object)id));
        return (SysKnowledgeDTO)ConvertUtils.sourceToTarget((Object)entity, SysKnowledgeDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public Result importByExcel(List<SysKnowledgeDTO> allList) {
        if (CollUtil.isNotEmpty(allList)) {
            SysKnowledgeEntity parent = (SysKnowledgeEntity)ConvertUtils.sourceToTarget((Object)allList.get(0), SysKnowledgeEntity.class);
            parent.setPid("0");
            this.insert((Object)parent);
            allList.remove(0);
            for (SysKnowledgeDTO dto : allList) {
                dto.setPid(parent.getId());
            }
            this.insertBatch((Collection)ConvertUtils.sourceToTarget(allList, SysKnowledgeEntity.class), 50);
        }
        return new Result();
    }
}

