/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.qgpatientview.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.qgpatientview.param.GetHistoryParam;
import io.huimu.modules.qgpatientview.param.GetTimeAxisDataParam;
import io.huimu.modules.qgpatientview.param.GetTimeAxisNodeInfoParam;
import io.huimu.modules.qgpatientview.param.GetVaAndIopAndRefAndLastParam;
import io.huimu.modules.qgpatientview.param.GetYanZouAndYanYaDataPram;
import io.huimu.modules.qgpatientview.service.Patient360Service;
import io.huimu.modules.qgpatientview.vo.YanYaAndYanZhouVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qg/patient/view"})
@Api(tags={"\u5c48\u5149\u60a3\u8005360\u89c6\u56fe"})
public class PatientViewController {
    @Autowired
    private Patient360Service patient360Service;

    @PostMapping(value={"getHistory"})
    @ApiOperation(value="\u75c5\u53f2\u603b\u89c8")
    @DecryptAndVerify(decryptedClass=GetHistoryParam.class)
    public Result getHistory(@RequestBody EncryptedReq<GetHistoryParam> req) {
        GetHistoryParam param = (GetHistoryParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.patient360Service.getHistory(param.getPatientId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getTimeAxisData"})
    @ApiOperation(value="\u83b7\u53d6\u65f6\u95f4\u8f74\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetTimeAxisDataParam.class)
    public Result getTimeAxisData(@RequestBody EncryptedReq<GetTimeAxisDataParam> req) {
        GetTimeAxisDataParam param = (GetTimeAxisDataParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.patient360Service.getTimeAxisData(param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getTimeAxisNodeInfo"})
    @ApiOperation(value="\u83b7\u53d6\u65f6\u95f4\u8f74\u8282\u70b9\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=GetTimeAxisNodeInfoParam.class)
    public Result getTimeAxisNodeInfo(@RequestBody EncryptedReq<GetTimeAxisNodeInfoParam> req) {
        GetTimeAxisNodeInfoParam param = (GetTimeAxisNodeInfoParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.patient360Service.getTimeAxisNodeInfo(param.getGroupName(), param.getDate(), param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getVaAndIopAndRefAndLast"})
    @ApiOperation(value="\u83b7\u53d6\u8272\u89c9\u89c6\u529b\u773c\u538b\u7535\u8111\u4e3b\u89c9\u9a8c\u5149\u548c\u6700\u8fd1\u89c6\u529b\u773c\u538b")
    @DecryptAndVerify(decryptedClass=GetVaAndIopAndRefAndLastParam.class)
    public Result getVaAndIopAndRefAndLast(@RequestBody EncryptedReq<GetVaAndIopAndRefAndLastParam> req) throws InterruptedException {
        GetVaAndIopAndRefAndLastParam param = (GetVaAndIopAndRefAndLastParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        ConcurrentHashMap map = this.patient360Service.getVaAndIopAndRefLast(param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)map);
    }

    @PostMapping(value={"getYanZouAndYanYaData"})
    @ApiOperation(value="\u83b7\u53d6\u773c\u8f74\u548c\u773c\u538b\u56fe\u8868\u7684\u503c")
    @DecryptAndVerify(decryptedClass=GetYanZouAndYanYaDataPram.class)
    public Result getYanZouAndYanYaData(@RequestBody EncryptedReq<GetYanZouAndYanYaDataPram> req) {
        GetYanZouAndYanYaDataPram param = (GetYanZouAndYanYaDataPram)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        YanYaAndYanZhouVO vo = this.patient360Service.getYanZouAndYanYaData(param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }
}

