/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.opera.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.opera.dto.CopyQgNumberSourceDTO;
import io.huimu.modules.opera.dto.CreateQgNumSourceDTO;
import io.huimu.modules.opera.dto.QgNumSourceDTO;
import io.huimu.modules.opera.param.GetNumSourceListParam;
import io.huimu.modules.opera.param.GetScheduleParam;
import io.huimu.modules.opera.service.QgNumSourceService;
import io.huimu.modules.opera.vo.DoctorOperaScheduleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qg/num/source"})
@Api(tags={"\u5c48\u5149\u53f7\u6e90\u7ba1\u7406"})
public class QgNumSourceController {
    @Autowired
    private QgNumSourceService qgNumSourceService;

    @PostMapping(value={"saveSource"})
    @ApiOperation(value="\u4fdd\u5b58\u53f7\u6e90")
    @LogOperation(value="\u4fdd\u5b58\u5c48\u5149\u53f7\u6e90", module="\u5c48\u5149\u53f7\u6e90\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=List.class)
    public Result saveSource(@RequestBody EncryptedReq<List<QgNumSourceDTO>> req) {
        List body = (List)req.getData();
        ValidatorUtils.validateEntity((Object)body, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.qgNumSourceService.saveSource(body);
        return new Result();
    }

    @PostMapping(value={"createNumSource"})
    @ApiOperation(value="\u751f\u6210\u53f7\u6e90")
    @LogOperation(value="\u751f\u6210\u53f7\u6e90", module="\u5c48\u5149\u53f7\u6e90\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=CreateQgNumSourceDTO.class)
    public Result createNumSource(@RequestBody EncryptedReq<CreateQgNumSourceDTO> req) {
        CreateQgNumSourceDTO dto = (CreateQgNumSourceDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        List list = this.qgNumSourceService.createNumSource(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"deleteQgNumSource"})
    @ApiOperation(value="\u5220\u9664\u53f7\u6e90")
    @LogOperation(value="\u5220\u9664\u53f7\u6e90", module="\u5c48\u5149\u53f7\u6e90\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result delete(@RequestBody EncryptedReq<ArraysParam> req) {
        Object[] ids = ((ArraysParam)req.getData()).getIds();
        AssertUtils.isArrayEmpty((Object[])ids, (String[])new String[]{"id"});
        this.qgNumSourceService.delete((String[])ids);
        return new Result();
    }

    @PostMapping(value={"updateSource"})
    @ApiOperation(value="\u4fee\u6539\u53f7\u6e90")
    @LogOperation(value="\u4fee\u6539\u53f7\u6e90", module="\u5c48\u5149\u53f7\u6e90\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=QgNumSourceDTO.class)
    public Result updateSource(@RequestBody EncryptedReq<QgNumSourceDTO> req) {
        QgNumSourceDTO dto = (QgNumSourceDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.qgNumSourceService.updateSource(dto);
        return new Result();
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u53f7\u6e90\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetNumSourceListParam.class)
    public Result getList(@RequestBody EncryptedReq<GetNumSourceListParam> req) {
        GetNumSourceListParam param = (GetNumSourceListParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.qgNumSourceService.getList(param);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"copyNumberSource"})
    @ApiOperation(value="\u590d\u5236\u53f7\u6e90")
    @LogOperation(value="\u590d\u5236\u53f7\u6e90", module="\u5c48\u5149\u53f7\u6e90\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=CopyQgNumberSourceDTO.class)
    public Result copyNumberSource(@RequestBody EncryptedReq<CopyQgNumberSourceDTO> req) {
        CopyQgNumberSourceDTO dto = (CopyQgNumberSourceDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.qgNumSourceService.copyNumberSource(dto);
        return new Result();
    }

    @PostMapping(value={"getScheduleList"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u672f\u65e5\u7a0b")
    @DecryptAndVerify(decryptedClass=GetScheduleParam.class)
    public Result<List<DoctorOperaScheduleVO>> getScheduleList(@RequestBody EncryptedReq<GetScheduleParam> req) throws IllegalAccessException {
        GetScheduleParam params = (GetScheduleParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        List list = this.qgNumSourceService.getScheduleList(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

