/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.service;

import cn.hutool.core.collection.CollUtil;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.IDUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.littlecheck.dao.LittleCheckDao;
import io.huimu.modules.littlecheck.dto.SaveShiLiDTO;
import io.huimu.modules.littlecheck.dto.SaveYanGuangDTO;
import io.huimu.modules.littlecheck.dto.SaveYanYaDTO;
import io.huimu.modules.littlecheck.dto.XjcPatientDTO;
import io.huimu.modules.littlecheck.dto.YanGuangBaseDTO;
import io.huimu.modules.littlecheck.dto.YanYaBaseDTO;
import io.huimu.modules.littlecheck.param.DelExamDataParam;
import io.huimu.modules.littlecheck.param.GetExamDataParam;
import io.huimu.modules.littlecheck.param.GetShiLiByDateParam;
import io.huimu.modules.littlecheck.param.GetYanGuangByDateParam;
import io.huimu.modules.littlecheck.param.GetYanYaByDateParam;
import io.huimu.modules.littlecheck.param.XjcPatientParam;
import io.huimu.modules.littlecheck.vo.GetShiLiByDateVO;
import io.huimu.modules.littlecheck.vo.GetYanGuangByDateVO;
import io.huimu.modules.littlecheck.vo.GetYanYaByDateVO;
import io.huimu.modules.outside.service.YtService;
import io.huimu.modules.security.user.SecurityUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LittleCheckService {
    @Autowired
    private LittleCheckDao littleCheckDao;
    @Autowired
    private YtService ytService;

    public List<XjcPatientDTO> getXjcPatientList(XjcPatientParam dto) {
        if (StringUtils.isBlank((CharSequence)dto.getSearchDay())) {
            dto.setSearchDay(DateUtils.format((Date)new Date()));
        }
        if (dto.getDataType() == 1) {
            return this.littleCheckDao.getXjcSlPatientList(dto);
        }
        if (dto.getDataType() == 2) {
            return this.littleCheckDao.getXjcYyPatientList(dto);
        }
        if (dto.getDataType() == 3) {
            return this.littleCheckDao.getXjcYgPatientList(dto);
        }
        return new ArrayList<XjcPatientDTO>();
    }

    public Result delExamData(DelExamDataParam dto) throws IllegalAccessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataType", dto.getDataType());
        param.put("id", dto.getId());
        param.put("delUserId", SecurityUser.getUser().getEmployeeId());
        param.put("delUserName", SecurityUser.getUser().getRealName());
        this.littleCheckDao.delExamData(param);
        Integer result = (Integer)param.get("result");
        if (result > 0) {
            this.ytService.asyncDeleteExamData(dto.getDataType(), dto.getId(), dto.getOrgCode(), 1);
            return new Result();
        }
        return new Result().error();
    }

    public List<LinkedHashMap<String, String>> getExamDataList(GetExamDataParam req) {
        List<LinkedHashMap<String, String>> list = new ArrayList<LinkedHashMap<String, String>>();
        if (req.getDataType() == 1) {
            list = this.littleCheckDao.getShiLiExamData(req.getPatientId(), req.getOrgCode(), req.getExamDate(), req.getBeginDate(), req.getEndDate());
        } else if (req.getDataType() == 2) {
            list = this.littleCheckDao.getYanYaExamData(req.getPatientId(), req.getOrgCode(), req.getExamDate(), req.getBeginDate(), req.getEndDate());
        } else if (req.getDataType() == 3) {
            list = this.littleCheckDao.getYanGuangExamData(req.getPatientId(), req.getYgType(), req.getOrgCode(), req.getExamDate(), req.getBeginDate(), req.getEndDate());
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveYanYaData(SaveYanYaDTO dto) throws IllegalAccessException {
        if (null != dto.getYanYaData()) {
            HashMap<String, String> data = new HashMap<String, String>();
            YanYaBaseDTO yanYaBaseDTO = dto.getYanYaData();
            yanYaBaseDTO.setCreateDate(new Date());
            String id = IDUtils.generateStringValue();
            Map param = MapUtils.object2Map((Object)yanYaBaseDTO);
            param.put("id", id);
            param.put("createUserId", SecurityUser.getEmployeeId());
            param.put("createUserName", SecurityUser.getUser().getRealName());
            param.put("createTime", DateUtils.format((Date)yanYaBaseDTO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            data.put("jsonStr", JsonUtils.toJsonString((Object)param));
            this.littleCheckDao.saveYanYaData(data);
            if (data.get("result").toString().equalsIgnoreCase("1")) {
                this.ytService.asyncYanYa(id, dto.getPatientIdNumber(), yanYaBaseDTO, 1);
                if (CollUtil.isNotEmpty((Collection)dto.getTestDataList())) {
                    for (int i = 0; i < dto.getTestDataList().size(); ++i) {
                        YanYaBaseDTO testDto = (YanYaBaseDTO)dto.getTestDataList().get(i);
                        testDto.setSortIndex(Integer.valueOf(i + 1));
                        Map testParam = MapUtils.object2Map((Object)testDto);
                        testParam.put("mainId", id);
                        testParam.put("createUserId", SecurityUser.getEmployeeId());
                        testParam.put("createUserName", SecurityUser.getUser().getRealName());
                        testParam.put("createTime", DateUtils.format((Date)dto.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                        data = new HashMap();
                        data.put("jsonStr", JsonUtils.toJsonString((Object)testParam));
                        this.littleCheckDao.saveYanYaTestData(data);
                    }
                }
            } else {
                throw new RenException("\u4fdd\u5b58\u5931\u8d25\uff0c" + data.get("outMsg"));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveYanGuangData(SaveYanGuangDTO dto) throws IllegalAccessException {
        if (null != dto.getYanGuangData()) {
            HashMap<String, String> data = new HashMap<String, String>();
            YanGuangBaseDTO yanGuangData = dto.getYanGuangData();
            yanGuangData.setCreateDate(new Date());
            String osId = IDUtils.generateStringValue();
            String odId = IDUtils.generateStringValue();
            Map param = MapUtils.object2Map((Object)yanGuangData);
            param.put("odId", odId);
            param.put("osId", osId);
            param.put("createUserId", SecurityUser.getEmployeeId());
            param.put("createUserName", SecurityUser.getUser().getRealName());
            param.put("createTime", DateUtils.format((Date)yanGuangData.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            data.put("jsonStr", JsonUtils.toJsonString((Object)param));
            this.littleCheckDao.saveYanGuangData(data);
            if (data.get("result").toString().equalsIgnoreCase("1")) {
                this.ytService.asyncYanGuang(odId, osId, dto.getPatientIdNumber(), yanGuangData, 1);
                if (CollUtil.isNotEmpty((Collection)dto.getTestDataList())) {
                    for (int i = 0; i < dto.getTestDataList().size(); ++i) {
                        YanGuangBaseDTO testDto = (YanGuangBaseDTO)dto.getTestDataList().get(i);
                        testDto.setSortIndex(Integer.valueOf(i + 1));
                        Map testParam = MapUtils.object2Map((Object)testDto);
                        testParam.put("odMainId", odId);
                        testParam.put("osMainId", osId);
                        testParam.put("createUserId", SecurityUser.getEmployeeId());
                        testParam.put("createUserName", SecurityUser.getUser().getRealName());
                        data = new HashMap();
                        data.put("jsonStr", JsonUtils.toJsonString((Object)testParam));
                        this.littleCheckDao.saveYanGuangTestData(data);
                    }
                }
            } else {
                throw new RenException("\u4fdd\u5b58\u5931\u8d25\uff0c" + data.get("outMsg"));
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveShiLiData(SaveShiLiDTO dto) throws IllegalAccessException {
        if (null != dto) {
            dto.setCreateDate(new Date());
            String id = IDUtils.generateStringValue();
            HashMap<String, String> data = new HashMap<String, String>();
            Map param = MapUtils.object2Map((Object)dto);
            param.put("id", id);
            param.put("createUserId", SecurityUser.getEmployeeId());
            param.put("createUserName", SecurityUser.getUser().getRealName());
            param.put("createTime", DateUtils.format((Date)dto.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            data.put("jsonStr", JsonUtils.toJsonString((Object)param));
            this.littleCheckDao.saveShiLiData(data);
            if (data.get("result").toString().equalsIgnoreCase("0")) {
                throw new RenException("\u4fdd\u5b58\u5931\u8d25\uff0c" + data.get("outMsg"));
            }
            this.ytService.asyncShiLi(id, dto, 1);
        }
    }

    public GetShiLiByDateVO getShiLiByDate(GetShiLiByDateParam dto) {
        return this.littleCheckDao.getShiLiByDate(dto);
    }

    public GetYanYaByDateVO getYanYaByDate(GetYanYaByDateParam dto) {
        return this.littleCheckDao.getYanYaByDate(dto);
    }

    public Map<String, GetYanGuangByDateVO> getYanGuangByDate(GetYanGuangByDateParam dto) {
        HashMap<String, GetYanGuangByDateVO> resMap = new HashMap<String, GetYanGuangByDateVO>();
        resMap.put("od", this.littleCheckDao.getYanGuangByDateOd(dto));
        resMap.put("os", this.littleCheckDao.getYanGuangByDateOs(dto));
        return resMap;
    }
}

