/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.examdatabrowse.service;

import cn.hutool.core.collection.CollUtil;
import io.huimu.modules.examdatabrowse.dao.ExamDataBrowseDao;
import io.huimu.modules.examdatabrowse.param.GetBrowsePatientParam;
import io.huimu.modules.examdatabrowse.param.GetExamFileParam;
import io.huimu.modules.examdatabrowse.param.GetExamItemParam;
import io.huimu.modules.examdatabrowse.vo.BrowseExamFilesVO;
import io.huimu.modules.examdatabrowse.vo.BrowseExamItemDataVO;
import io.huimu.modules.examdatabrowse.vo.BrowseExamItemTreeVO;
import io.huimu.modules.examdatabrowse.vo.BrowsePatientVO;
import io.huimu.modules.examdatabrowse.vo.RegisterPatientVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamDataBrowseService {
    @Autowired
    private ExamDataBrowseDao browseDao;

    public BrowsePatientVO getBrowsePatientInfo(GetBrowsePatientParam data) {
        BrowsePatientVO resultVo = new BrowsePatientVO();
        List<String> pids = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)data.getPatientIdNumber())) {
            pids = this.browseDao.getPIdsByIdNumber(data.getPatientIdNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)data.getPatientId())) {
            pids.add(data.getPatientId());
        }
        if (CollUtil.isEmpty(pids)) {
            return resultVo;
        }
        RegisterPatientVO vo = this.browseDao.getBrowsePatientInfo(data.getPatientId(), data.getPatientIdNumber());
        if (null != vo) {
            resultVo.setPatientInfo(vo);
            resultVo.setShiLiList(this.browseDao.getShiLi(pids));
            resultVo.setYanYaList(this.browseDao.getYanYa(pids));
            resultVo.setRegisterRecord(this.browseDao.getRegisterRecord(pids));
            resultVo.setRegisterDataSource(this.browseDao.getRegisterDataSource(pids));
        }
        return resultVo;
    }

    public List<BrowseExamItemTreeVO> getExamItem(GetExamItemParam data) {
        List<String> pids = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)data.getPatientIdNumber())) {
            pids = this.browseDao.getPIdsByIdNumber(data.getPatientIdNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)data.getPatientId())) {
            pids.add(data.getPatientId());
        }
        if (CollUtil.isEmpty(pids)) {
            return new ArrayList<BrowseExamItemTreeVO>();
        }
        List list = this.browseDao.getExamItem(pids);
        if (data.getType() == 1) {
            return this.handleTimeTree(list);
        }
        return this.handleProjectTree(list);
    }

    private List<BrowseExamItemTreeVO> handleTimeTree(List<BrowseExamItemDataVO> data) {
        ArrayList<BrowseExamItemTreeVO> list = new ArrayList<BrowseExamItemTreeVO>();
        if (CollUtil.isNotEmpty(data)) {
            for (BrowseExamItemDataVO vo : data) {
                BrowseExamItemTreeVO treeVO;
                Optional<BrowseExamItemTreeVO> optional = list.stream().filter(dto -> dto.getId().equalsIgnoreCase(vo.getExamTime())).findFirst();
                if (optional.isPresent()) {
                    treeVO = optional.get();
                    treeVO.getExamItemVOS().add(vo);
                    continue;
                }
                treeVO = new BrowseExamItemTreeVO();
                treeVO.setId(vo.getExamTime());
                treeVO.setName(vo.getExamTime());
                ArrayList<BrowseExamItemDataVO> dataVOList = new ArrayList<BrowseExamItemDataVO>();
                dataVOList.add(vo);
                treeVO.setExamItemVOS(dataVOList);
                list.add(treeVO);
            }
        }
        return list;
    }

    private List<BrowseExamItemTreeVO> handleProjectTree(List<BrowseExamItemDataVO> data) {
        ArrayList<BrowseExamItemTreeVO> list = new ArrayList<BrowseExamItemTreeVO>();
        if (CollUtil.isNotEmpty(data)) {
            for (BrowseExamItemDataVO vo : data) {
                BrowseExamItemTreeVO treeVO;
                Optional<BrowseExamItemTreeVO> optional = list.stream().filter(dto -> dto.getId().equalsIgnoreCase(vo.getExamItemCode())).findFirst();
                if (optional.isPresent()) {
                    treeVO = optional.get();
                    treeVO.getExamItemVOS().add(vo);
                    continue;
                }
                treeVO = new BrowseExamItemTreeVO();
                treeVO.setId(vo.getExamItemCode());
                treeVO.setName(vo.getExamItem());
                ArrayList<BrowseExamItemDataVO> dataVOList = new ArrayList<BrowseExamItemDataVO>();
                dataVOList.add(vo);
                treeVO.setExamItemVOS(dataVOList);
                list.add(treeVO);
            }
        }
        return list;
    }

    public List<List<BrowseExamFilesVO>> getExamFiles(GetExamFileParam dto) {
        List<String> pids = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)dto.getPatientIdNumber())) {
            pids = this.browseDao.getPIdsByIdNumber(dto.getPatientIdNumber());
        } else {
            pids.add(dto.getPatientId());
        }
        if (CollUtil.isEmpty(pids)) {
            return new ArrayList<List<BrowseExamFilesVO>>();
        }
        List examNoList = this.browseDao.getExamNoList(pids, dto.getExamDate(), dto.getItemCode(), dto.getExamNo());
        ArrayList<List<BrowseExamFilesVO>> resList = new ArrayList<List<BrowseExamFilesVO>>();
        if (CollUtil.isNotEmpty((Collection)examNoList)) {
            List fileList = this.browseDao.getExamFiles(examNoList, dto.getEyeType(), dto.getFileType());
            Map<String, List<BrowseExamFilesVO>> map = fileList.stream().collect(Collectors.groupingBy(BrowseExamFilesVO::getId));
            for (String key : map.keySet()) {
                List list = map.get(key).stream().collect(Collectors.toList());
                list.sort(Comparator.comparing(BrowseExamFilesVO::getFileSort).thenComparing(BrowseExamFilesVO::getExamTime, Comparator.reverseOrder()));
                resList.add(list);
            }
        }
        return resList;
    }
}

