/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictExamAddressDao;
import io.huimu.modules.dict.dto.DictExamAddressDTO;
import io.huimu.modules.dict.entity.DictExamAddressEntity;
import io.huimu.modules.dict.param.DictExamAddressListParam;
import io.huimu.modules.dict.service.DictExamAddressItemService;
import io.huimu.modules.dict.service.DictExamAddressService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictExamAddressServiceImpl
extends BaseServiceImpl<DictExamAddressDao, DictExamAddressEntity>
implements DictExamAddressService {
    @Autowired
    private DictExamAddressItemService dictExamAddressItemService;

    public PageData<DictExamAddressDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"examAddress"});
        IPage page = this.getPage(params, "", false);
        List list = ((DictExamAddressDao)this.baseDao).getList(params);
        List resList = ConvertUtils.sourceToTarget((Collection)list, DictExamAddressDTO.class);
        for (DictExamAddressDTO dto : resList) {
            dto.setExamNameList(((DictExamAddressDao)this.baseDao).getExamItemList(dto.getId()));
        }
        return this.getPageData(resList, page.getTotal(), DictExamAddressDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(DictExamAddressDTO dto) {
        DictExamAddressEntity entity = (DictExamAddressEntity)ConvertUtils.sourceToTarget((Object)dto, DictExamAddressEntity.class);
        entity.setCreateDate(new Date());
        this.insert((Object)entity);
        this.dictExamAddressItemService.saveOrUpdate(entity.getId(), dto.getOrgCode(), dto.getExamCodeList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(DictExamAddressDTO dto) {
        DictExamAddressEntity entity = (DictExamAddressEntity)ConvertUtils.sourceToTarget((Object)dto, DictExamAddressEntity.class);
        entity.setCreateDate(new Date());
        this.updateById((Object)entity);
        this.dictExamAddressItemService.saveOrUpdate(entity.getId(), dto.getOrgCode(), dto.getExamCodeList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        ((DictExamAddressDao)this.baseDao).deleteById((Serializable)((Object)id));
        this.dictExamAddressItemService.deleteByAddressId(id);
    }

    public List<DictExamAddressDTO> getListByExamCode(String orgCode, String examCode) {
        if (StringUtils.isNotBlank((CharSequence)examCode)) {
            return ((DictExamAddressDao)this.baseDao).getListByExamCode(orgCode, examCode);
        }
        return ((DictExamAddressDao)this.baseDao).getAllList(orgCode);
    }

    public List<DictExamAddressEntity> getList(DictExamAddressListParam dto) {
        return ((DictExamAddressDao)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)dto.getOrgCode()));
    }
}

