/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.sys.dao.SysSystemConfDao;
import io.huimu.modules.sys.dto.SysSystemConfDTO;
import io.huimu.modules.sys.entity.SysSystemConfEntity;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.vo.SysSystemConfVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysSystemConfServiceImpl
extends BaseServiceImpl<SysSystemConfDao, SysSystemConfEntity>
implements SysSystemConfService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public PageData<SysSystemConfVO> page(Map<String, Object> params) {
        IPage page = ((SysSystemConfDao)this.baseDao).selectPage(this.getPage(params, "create_date", false), (Wrapper)this.getWrapper(params));
        return this.getPageData(page, SysSystemConfVO.class);
    }

    private QueryWrapper<SysSystemConfEntity> getWrapper(Map<String, Object> params) {
        String confCode = (String)params.get("confCode");
        String confMsg = (String)params.get("confMsg");
        String remark = (String)params.get("remark");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByAsc((Object)"CONF_CODE");
        wrapper.like(StringUtils.isNotBlank((CharSequence)confCode), (Object)"CONF_CODE", (Object)confCode);
        wrapper.like(StringUtils.isNotBlank((CharSequence)confMsg), (Object)"CONF_MSG", (Object)confMsg);
        wrapper.like(StringUtils.isNotBlank((CharSequence)remark), (Object)"REMARK", (Object)remark);
        return wrapper;
    }

    public SysSystemConfVO getInfo(String confCode) {
        SysSystemConfEntity entity = (SysSystemConfEntity)((SysSystemConfDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"CONF_CODE", (Object)confCode));
        return (SysSystemConfVO)ConvertUtils.sourceToTarget((Object)entity, SysSystemConfVO.class);
    }

    public void updateMsg(SysSystemConfDTO dto) {
        SysSystemConfEntity entity = (SysSystemConfEntity)ConvertUtils.sourceToTarget((Object)dto, SysSystemConfEntity.class);
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"CONF_CODE", (Object)entity.getConfCode()));
    }

    public String getConfValue(String confCode, String defaultMsg) {
        SysSystemConfEntity entity = (SysSystemConfEntity)((SysSystemConfDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"CONF_CODE", (Object)confCode));
        if (null != entity) {
            return entity.getConfMsg();
        }
        return defaultMsg;
    }

    public Result saveMsg(SysSystemConfDTO dto) {
        int count = ((SysSystemConfDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"CONF_CODE", (Object)dto.getConfCode()));
        if (count > 0) {
            String msg = this.sysSystemConfService.getConfValue("100011", "code\u5df2\u5b58\u5728");
            return new Result().error(msg);
        }
        SysSystemConfEntity entity = (SysSystemConfEntity)ConvertUtils.sourceToTarget((Object)dto, SysSystemConfEntity.class);
        this.insert((Object)entity);
        return new Result();
    }

    public List<SysSystemConfVO> getList() {
        List list = ((SysSystemConfDao)this.baseDao).selectList((Wrapper)new QueryWrapper());
        return ConvertUtils.sourceToTarget((Collection)list, SysSystemConfVO.class);
    }

    public String getCaFlag() {
        return this.sysSystemConfService.getConfValue("100015", "0");
    }
}

