/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysKnowledgeDTO;
import io.huimu.modules.sys.dto.UploadKnowledgeDTO;
import io.huimu.modules.sys.excel.SysKnowledgeExcel;
import io.huimu.modules.sys.param.DelKnowParam;
import io.huimu.modules.sys.param.GetKnowInfoParam;
import io.huimu.modules.sys.param.KnowPageParam;
import io.huimu.modules.sys.param.KnowSearchParam;
import io.huimu.modules.sys.service.SysKnowledgeService;
import io.huimu.modules.sys.vo.SysKnowledgeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/know"})
@Api(tags={"\u77e5\u8bc6\u5e93\u7ba1\u7406"})
public class SysKnowledgeController {
    @Autowired
    private SysKnowledgeService knowledgeService;

    @PostMapping(value={"saveKnow"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u4fdd\u5b58\u77e5\u8bc6\u5e93", module="\u77e5\u8bc6\u5e93\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysKnowledgeDTO.class)
    public Result saveKnow(@RequestBody EncryptedReq<SysKnowledgeDTO> req) {
        SysKnowledgeDTO dto = (SysKnowledgeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.knowledgeService.saveKnow(dto);
        return new Result();
    }

    @PostMapping(value={"updateKnow"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539\u77e5\u8bc6\u5e93", module="\u77e5\u8bc6\u5e93\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysKnowledgeDTO.class)
    public Result updateKnow(@RequestBody EncryptedReq<SysKnowledgeDTO> req) {
        SysKnowledgeDTO dto = (SysKnowledgeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.knowledgeService.updateKnow(dto);
        return new Result();
    }

    @PostMapping(value={"getKnowPage"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u5217\u8868")
    @DecryptAndVerify(decryptedClass=KnowPageParam.class)
    public Result<PageData<SysKnowledgeDTO>> getKnowPage(@RequestBody EncryptedReq<KnowPageParam> req) throws IllegalAccessException {
        KnowPageParam dto = (KnowPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.knowledgeService.getKnowPage(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"batchDelKnow"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DecryptAndVerify(decryptedClass=DelKnowParam.class)
    @LogOperation(value="\u6279\u91cf\u5220\u9664\u77e5\u8bc6\u5e93", module="\u77e5\u8bc6\u5e93\u7ba1\u7406", operationType=1)
    public Result batchDelKnow(@RequestBody EncryptedReq<DelKnowParam> req) {
        DelKnowParam dto = (DelKnowParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.knowledgeService.batchDelKnow(dto.getId());
        return new Result();
    }

    @PostMapping(value={"getKnowList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=KnowSearchParam.class)
    public Result<List<SysKnowledgeVO>> getKnowList(@RequestBody EncryptedReq<KnowSearchParam> req) throws IllegalAccessException {
        KnowSearchParam dto = (KnowSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.knowledgeService.getKnowList(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getKnowInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetKnowInfoParam.class)
    public Result<SysKnowledgeDTO> getKnowInfo(@RequestBody EncryptedReq<GetKnowInfoParam> req) {
        GetKnowInfoParam dto = (GetKnowInfoParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysKnowledgeDTO vo = this.knowledgeService.getKnowInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"exportTemp"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f")
    public void exportTemp(HttpServletResponse response) throws Exception {
        ArrayList<SysKnowledgeDTO> list = new ArrayList<SysKnowledgeDTO>();
        SysKnowledgeDTO dto = new SysKnowledgeDTO();
        dto.setKnowCode("syjc");
        dto.setKnowName("\u89c6\u91ce\u68c0\u67e5");
        dto.setSortIndex(Integer.valueOf(1));
        list.add(dto);
        dto = new SysKnowledgeDTO();
        dto.setKnowCode("zdsyjjc");
        dto.setKnowName("\u81ea\u52a8\u89c6\u91ce\u8ba1\u68c0\u67e5");
        dto.setSyz("\u9002\u5e94\u75c7\u5185\u5bb9");
        dto.setJjz("\u7981\u5fcc\u75c7\u5185\u5bb9");
        dto.setZysx("\u6ce8\u610f\u4e8b\u9879\u5185\u5bb9");
        dto.setCzff("\u64cd\u4f5c\u65b9\u6cd5\u5185\u5bb9");
        dto.setSortIndex(Integer.valueOf(1));
        list.add(dto);
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u533b\u6280", list, SysKnowledgeExcel.class);
    }

    @PostMapping(value={"importByExcel"})
    @ApiOperation(value="excel\u5bfc\u5165\u533b\u6280")
    public Result importByExcel(UploadKnowledgeDTO dto) throws IOException {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        ArrayList allList = new ArrayList();
        EasyExcel.read((InputStream)dto.getFile().getInputStream(), SysKnowledgeExcel.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).doReadAll();
        return this.knowledgeService.importByExcel(allList);
    }
}

