/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.qgpatientwyreason.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.IdsParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.qgpatientwyreason.dto.QgPatientWyReasonDTO;
import io.huimu.modules.qgpatientwyreason.entity.QgPatientWyReasonEntity;
import io.huimu.modules.qgpatientwyreason.param.GetReasonListParam;
import io.huimu.modules.qgpatientwyreason.service.QgPatientWyReasonService;
import io.huimu.modules.security.user.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qg/patient/wy/reason"})
@Api(tags={"\u5c48\u5149\u60a3\u8005\u672a\u7ea6\u539f\u56e0\u7ba1\u7406"})
public class QgPatientWyReasonController {
    @Autowired
    private QgPatientWyReasonService qgPatientWyReasonService;

    @PostMapping(value={"saveReason"})
    @ApiOperation(value="\u589e\u52a0\u539f\u56e0")
    @LogOperation(value="\u589e\u52a0\u539f\u56e0", module="\u5c48\u5149\u60a3\u8005\u672a\u7ea6\u539f\u56e0\u7ba1\u7406", operationType=1)
    public Result saveReason(@RequestBody EncryptedReq<QgPatientWyReasonDTO> req) {
        QgPatientWyReasonDTO dto = (QgPatientWyReasonDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.qgPatientWyReasonService.saveReason(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u539f\u56e0")
    @LogOperation(value="\u5220\u9664\u539f\u56e0", module="\u5c48\u5149\u60a3\u8005\u672a\u7ea6\u539f\u56e0\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdsParam.class)
    public Result delete(@RequestBody EncryptedReq<IdsParam> req) {
        IdsParam dto = (IdsParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.qgPatientWyReasonService.deleteBatchIds((Collection)dto.getId());
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u539f\u56e0")
    @LogOperation(value="\u4fee\u6539\u539f\u56e0", module="\u5c48\u5149\u60a3\u8005\u672a\u7ea6\u539f\u56e0\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=QgPatientWyReasonDTO.class)
    public Result update(@RequestBody EncryptedReq<QgPatientWyReasonDTO> req) {
        QgPatientWyReasonDTO dto = (QgPatientWyReasonDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        QgPatientWyReasonEntity entity = (QgPatientWyReasonEntity)ConvertUtils.sourceToTarget((Object)dto, QgPatientWyReasonEntity.class);
        entity.setCreateDate(DateUtils.format((Date)new Date()));
        entity.setCreateTime(new Date());
        entity.setCreateUserCode(SecurityUser.getEmployeeId());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        this.qgPatientWyReasonService.updateById((Object)entity);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        QgPatientWyReasonEntity entity = (QgPatientWyReasonEntity)this.qgPatientWyReasonService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, QgPatientWyReasonDTO.class));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetReasonListParam.class)
    public Result<List<QgPatientWyReasonDTO>> getXjList(@RequestBody EncryptedReq<GetReasonListParam> req) {
        GetReasonListParam dto = (GetReasonListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.qgPatientWyReasonService.getList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

