/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patient.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.PatientIdParam;
import io.huimu.common.param.PatientPageParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.outside.service.QueryPatientService;
import io.huimu.modules.patient.dto.PatientDTO;
import io.huimu.modules.patient.param.QueryHisPatientParam;
import io.huimu.modules.patient.service.PatientService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patient"})
@Api(tags={"\u60a3\u8005\u7ba1\u7406"})
public class PatientController {
    @Autowired
    private PatientService patientService;
    @Autowired
    private QueryPatientService queryPatientService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=PatientPageParam.class)
    public Result<PageData<PatientDTO>> page(@RequestBody EncryptedReq<PatientPageParam> req) throws IllegalAccessException {
        PatientPageParam data = (PatientPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.patientService.page(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=PatientIdParam.class)
    public Result<PatientDTO> getInfo(@RequestBody EncryptedReq<PatientIdParam> req) {
        PatientIdParam data = (PatientIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        PatientDTO dto = this.patientService.getInfo(data.getPatientId(), data.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"updatePatient"})
    @ApiOperation(value="\u4fee\u6539\u60a3\u8005")
    @LogOperation(value="\u4fee\u6539\u60a3\u8005", module="\u60a3\u8005\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=PatientDTO.class)
    public Result updatePatient(@RequestBody EncryptedReq<PatientDTO> req) {
        PatientDTO dto = (PatientDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.patientService.updatePatient(dto);
    }

    @PostMapping(value={"savePatient"})
    @ApiOperation(value="\u6dfb\u52a0\u60a3\u8005")
    @LogOperation(value="\u6dfb\u52a0\u60a3\u8005", module="\u60a3\u8005\u7ba1\u7406", operationType=1)
    public Result savePatient(@RequestBody PatientDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.patientService.savePatient(dto);
    }

    @PostMapping(value={"deletePatient"})
    @ApiOperation(value="\u5220\u9664\u60a3\u8005")
    @LogOperation(value="\u5220\u9664\u60a3\u8005", module="\u60a3\u8005\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=PatientIdParam.class)
    public Result deletePatient(@RequestBody EncryptedReq<PatientIdParam> req) {
        PatientIdParam data = (PatientIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        return this.patientService.deletePatient(data.getPatientId(), data.getOrgCode());
    }

    @PostMapping(value={"queryHisPatient"})
    @ApiOperation(value="\u67e5\u8be2his\u60a3\u8005")
    @DecryptAndVerify(decryptedClass=QueryHisPatientParam.class)
    public Result queryHisPatient(@RequestBody EncryptedReq<QueryHisPatientParam> req) throws IOException {
        QueryHisPatientParam data = (QueryHisPatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        return this.queryPatientService.queryHisPatient(data);
    }
}

