/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.opera.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.opera.dto.BatchYuYueOperaDTO;
import io.huimu.modules.opera.dto.QgOperaDTO;
import io.huimu.modules.opera.dto.QgOperaStatusDTO;
import io.huimu.modules.opera.dto.SaveNoYuYueOperaDTO;
import io.huimu.modules.opera.excel.OperaListExcel;
import io.huimu.modules.opera.param.CancelOperaParam;
import io.huimu.modules.opera.param.FinalOperaParam;
import io.huimu.modules.opera.param.GetOperaListParam;
import io.huimu.modules.opera.param.GetQgOperaPageParam;
import io.huimu.modules.opera.param.GetQgYuYueOperaPageParam;
import io.huimu.modules.opera.param.GetYuYuePatientParam;
import io.huimu.modules.opera.param.PostExportOperaParam;
import io.huimu.modules.opera.param.UpdateOperaSortParam;
import io.huimu.modules.opera.service.QgOperaService;
import io.huimu.modules.opera.vo.QgOperaVO;
import io.huimu.modules.opera.vo.QgReservationPatientVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/qg/opera"})
@Api(tags={"\u5c48\u5149\u624b\u672f\u7ba1\u7406"})
public class QgOperaController {
    @Autowired
    private QgOperaService operaService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5c48\u5149\u624b\u672f\u5217\u8868\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetQgOperaPageParam.class)
    public Result<PageData<QgOperaVO>> page(@RequestBody EncryptedReq<GetQgOperaPageParam> req) throws IllegalAccessException {
        GetQgOperaPageParam pageParam = (GetQgOperaPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)pageParam, (Class[])new Class[0]);
        PageData page = this.operaService.page(MapUtils.object2Map((Object)pageParam));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"postExportOpera"})
    @ApiOperation(value="post\u5bfc\u51fa\u624b\u672f")
    @DecryptAndVerify(decryptedClass=PostExportOperaParam.class)
    public void postExportOpera(@RequestBody EncryptedReq<PostExportOperaParam> req, HttpServletResponse response) throws Exception {
        PostExportOperaParam pageParam = (PostExportOperaParam)req.getData();
        ValidatorUtils.validateEntity((Object)pageParam, (Class[])new Class[0]);
        List list = this.operaService.getExportOperaList(MapUtils.object2Map((Object)pageParam));
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u624b\u672f\u5217\u8868", (List)list, OperaListExcel.class);
    }

    @GetMapping(value={"exportOpera"})
    @ApiOperation(value="\u5bfc\u51fa\u624b\u672f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCode", value="\u673a\u6784code", paramType="query", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="patientId", value="\u75c5\u5386\u53f7", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="patientName", value="\u60a3\u8005\u59d3\u540d", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="beginDate", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="endDate", value="\u7ed3\u675f\u65e5\u671f", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="operaName", value="\u624b\u672f\u65b9\u5f0f", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="doctorCode", value="\u4e3b\u5200\u533b\u751fcode", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="operaStatus", value="\u624b\u672f\u72b6\u6001\uff0c0:\u672a\u9884\u7ea6\uff0c100:\u5df2\u9884\u7ea6\u672a\u624b\u672f\uff0c200\uff1a\u547c\u53eb\u4e2d\uff0c300\uff1a\u624b\u672f\u4e2d\uff0c400\uff1a\u624b\u672f\u5b8c\u6210", paramType="query", dataTypeClass=Integer.class), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="orderField", value="\u6392\u5e8f\u5b57\u6bb5", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", paramType="query", dataTypeClass=String.class)})
    public void exportOpera(@ApiIgnore @RequestParam Map<String, Object> params, HttpServletResponse response) throws Exception {
        List list = this.operaService.getExportOperaList(params);
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u624b\u672f\u5217\u8868", (List)list, OperaListExcel.class);
    }

    @PostMapping(value={"getOperaList"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u5c48\u5149\u624b\u672f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetOperaListParam.class)
    public Result<List<QgOperaVO>> getOperaList(@RequestBody EncryptedReq<GetOperaListParam> req) {
        GetOperaListParam param = (GetOperaListParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.operaService.getOperaList(param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getYuYuePage"})
    @ApiOperation(value="\u83b7\u53d6\u5c48\u5149\u9884\u7ea6\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetQgYuYueOperaPageParam.class)
    public Result<PageData<QgOperaVO>> getYuYuePage(@RequestBody EncryptedReq<GetQgYuYueOperaPageParam> req) throws IllegalAccessException {
        GetQgYuYueOperaPageParam param = (GetQgYuYueOperaPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.operaService.getYuYuePage(MapUtils.object2Map((Object)param));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"saveNoYuYueOpera"})
    @ApiOperation(value="\u4fdd\u5b58\u5c48\u5149\u624b\u672f\u672a\u9884\u7ea6\u4fe1\u606f")
    @LogOperation(value="\u4fdd\u5b58\u5c48\u5149\u624b\u672f\u672a\u9884\u7ea6\u4fe1\u606f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SaveNoYuYueOperaDTO.class)
    public Result saveNoYuYueOpera(@RequestBody EncryptedReq<SaveNoYuYueOperaDTO> req) {
        SaveNoYuYueOperaDTO dto = (SaveNoYuYueOperaDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.operaService.saveNoYuYueOpera(dto);
        return new Result();
    }

    @PostMapping(value={"batchYuYueOpera"})
    @ApiOperation(value="\u6279\u91cf\u9884\u7ea6\u5c48\u5149\u624b\u672f")
    @LogOperation(value="\u6279\u91cf\u9884\u7ea6\u5c48\u5149\u624b\u672f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=QgOperaDTO.class)
    public Result batchYuYueOpera(@RequestBody EncryptedReq<BatchYuYueOperaDTO> req) {
        BatchYuYueOperaDTO dto = (BatchYuYueOperaDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.operaService.batchYuYueOpera(dto);
        return new Result();
    }

    @PostMapping(value={"saveOpera"})
    @ApiOperation(value="\u4fdd\u5b58\u5c48\u5149\u624b\u672f\u9884\u7ea6\u4fe1\u606f")
    @LogOperation(value="\u4fdd\u5b58\u5c48\u5149\u624b\u672f\u9884\u7ea6\u4fe1\u606f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=QgOperaDTO.class)
    public Result saveOpera(@RequestBody EncryptedReq<QgOperaDTO> req) {
        QgOperaDTO dto = (QgOperaDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.operaService.saveOpera(dto);
        return new Result();
    }

    @PostMapping(value={"updateOpera"})
    @ApiOperation(value="\u4fee\u6539\u5c48\u5149\u624b\u672f\u9884\u7ea6\u4fe1\u606f")
    @LogOperation(value="\u4fee\u6539\u5c48\u5149\u624b\u672f\u9884\u7ea6\u4fe1\u606f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=QgOperaDTO.class)
    public Result updateOpera(@RequestBody EncryptedReq<QgOperaDTO> req) {
        QgOperaDTO dto = (QgOperaDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.operaService.updateOpera(dto);
        return new Result();
    }

    private void judgeMainOperaEye(QgOperaDTO dto) {
        ArrayList<String> mainEye = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)dto.getOuOpera())) {
            mainEye.add("OU");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOdOpera())) {
            mainEye.add("OD");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOsOpera())) {
            mainEye.add("OS");
        }
        if (mainEye.indexOf(dto.getMainOperaEye()) < 0) {
            throw new RenException("\u4e3b\u624b\u672f\u773c\u522b\u9009\u62e9\u6709\u8bef");
        }
    }

    @PostMapping(value={"updateOperaStatus"})
    @ApiOperation(value="\u66f4\u65b0\u5c48\u5149\u624b\u672f\u72b6\u6001")
    @LogOperation(value="\u66f4\u65b0\u5c48\u5149\u624b\u672f\u72b6\u6001", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=QgOperaStatusDTO.class)
    public Result updateOperaStatus(@RequestBody EncryptedReq<QgOperaStatusDTO> req) {
        QgOperaStatusDTO dto = (QgOperaStatusDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.operaService.updateOperaStatus(dto);
        return new Result();
    }

    @PostMapping(value={"updateOperaSort"})
    @ApiOperation(value="\u66f4\u65b0\u624b\u672f\u6392\u5e8f")
    @LogOperation(value="\u66f4\u65b0\u624b\u672f\u6392\u5e8f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=UpdateOperaSortParam.class)
    public Result updateOperaSort(@RequestBody EncryptedReq<UpdateOperaSortParam> req) {
        UpdateOperaSortParam dto = (UpdateOperaSortParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.operaService.updateOperaSort(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5c48\u5149\u624b\u672f\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        AssertUtils.isBlank((String)dto.getId(), (String[])new String[]{"\u624b\u672fid"});
        QgOperaDTO qgOperaDTO = this.operaService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)qgOperaDTO);
    }

    @PostMapping(value={"cancelOpera"})
    @ApiOperation(value="\u53d6\u6d88\u5c48\u5149\u624b\u672f")
    @LogOperation(value="\u53d6\u6d88\u5c48\u5149\u624b\u672f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=CancelOperaParam.class)
    public Result cancelOpera(@RequestBody EncryptedReq<CancelOperaParam> req) {
        CancelOperaParam dto = (CancelOperaParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.operaService.cancelOpera(dto);
        return new Result();
    }

    @PostMapping(value={"deleteOpera"})
    @ApiOperation(value="\u5220\u9664\u5c48\u5149\u624b\u672f")
    @LogOperation(value="\u5220\u9664\u5c48\u5149\u624b\u672f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteOpera(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        AssertUtils.isBlank((String)dto.getId(), (String[])new String[]{"\u624b\u672fid"});
        this.operaService.deleteOpera(dto.getId());
        return new Result();
    }

    @PostMapping(value={"updateFinalOpera"})
    @ApiOperation(value="\u66f4\u65b0\u6700\u7ec8\u5c48\u5149\u624b\u672f")
    @LogOperation(value="\u66f4\u65b0\u6700\u7ec8\u5c48\u5149\u624b\u672f", module="\u5c48\u5149\u624b\u672f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result updateFinalOpera(@RequestBody EncryptedReq<FinalOperaParam> req) {
        FinalOperaParam dto = (FinalOperaParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.operaService.updateFinalOpera(dto);
        return new Result();
    }

    @PostMapping(value={"getPatientList"})
    @ApiOperation(value="\u83b7\u53d6\u9884\u7ea6\u7684\u60a3\u8005\u5217\u8868\uff08\u65e5\u7a0b\u4e2d\u7684\u8be6\u60c5\uff09")
    @DecryptAndVerify(decryptedClass=GetYuYuePatientParam.class)
    public Result<List<QgReservationPatientVO>> getPatientList(@RequestBody EncryptedReq<GetYuYuePatientParam> req) throws IllegalAccessException {
        GetYuYuePatientParam dto = (GetYuYuePatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.operaService.getPatientList(MapUtils.object2Map((Object)dto));
        return new Result().ok((Object)list);
    }
}

