/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.license.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.CustomizeEncryUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.MachineCodeUtil;
import io.huimu.common.utils.NumberUtils;
import io.huimu.modules.license.dao.LicenseDao;
import io.huimu.modules.license.dto.DecryptLicenseDTO;
import io.huimu.modules.license.dto.LicenseDTO;
import io.huimu.modules.license.entity.LicenseEntity;
import io.huimu.modules.license.service.LicenseService;
import io.huimu.modules.license.vo.LicenseVO;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
extends BaseServiceImpl<LicenseDao, LicenseEntity>
implements LicenseService {
    @Autowired
    private SysExamDeviceConfService sysExamDeviceConfService;

    public LicenseVO saveLicense(LicenseDTO dto) {
        LicenseVO vo = new LicenseVO();
        String unCrypStr = CustomizeEncryUtils.uncrypXML((String)dto.getLicenseSign());
        if (StringUtils.isBlank((CharSequence)unCrypStr)) {
            throw new RenException("\u6388\u6743\u7801\u89e3\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        DecryptLicenseDTO decryptLicenseDTO = (DecryptLicenseDTO)JSON.parseObject((String)unCrypStr, DecryptLicenseDTO.class);
        if (null == decryptLicenseDTO) {
            throw new RenException("\u6388\u6743\u7801\u53cd\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (!decryptLicenseDTO.getComputerCode().equalsIgnoreCase(dto.getComputerCode())) {
            throw new RenException("\u670d\u52a1\u5668\u673a\u5668\u7801\u4e0e\u6388\u6743\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (StringUtils.isBlank((CharSequence)decryptLicenseDTO.getSqDate())) {
            vo.setCheckFlag(Integer.valueOf(-1));
            vo.setMessage("\u6388\u6743\u7801\u65e5\u671f\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        } else {
            Integer num = DateUtils.subtractionDay((String)decryptLicenseDTO.getSqDate(), (String)DateUtils.format((Date)new Date()));
            if (num < 0) {
                vo.setCheckFlag(Integer.valueOf(-2));
                vo.setMessage("\u6388\u6743\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
            } else if (num >= 0 && num <= 60) {
                vo.setCheckFlag(Integer.valueOf(1));
                vo.setMessage("\u8ddd\u79bb\u6388\u6743\u8fc7\u671f\u8fd8\u5269" + num + "\u5929\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u5382\u5546\u5ef6\u957f\u6388\u6743\u7801\u65f6\u95f4");
                vo.setSyDays(num);
                vo.setComputerCode(dto.getComputerCode());
                vo.setLicenseType(dto.getLicenseType());
                vo.setSqDate(decryptLicenseDTO.getSqDate());
                vo.setSqNum(decryptLicenseDTO.getSqNum());
                ((LicenseDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)dto.getLicenseType()));
                this.insert(ConvertUtils.sourceToTarget((Object)dto, LicenseEntity.class));
            } else {
                ((LicenseDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)dto.getLicenseType()));
                this.insert(ConvertUtils.sourceToTarget((Object)dto, LicenseEntity.class));
                vo.setCheckFlag(Integer.valueOf(0));
                vo.setComputerCode(dto.getComputerCode());
                vo.setLicenseType(dto.getLicenseType());
                vo.setSqDate(decryptLicenseDTO.getSqDate());
                vo.setSqNum(decryptLicenseDTO.getSqNum());
            }
        }
        return vo;
    }

    public LicenseVO checkLicense() throws IOException {
        LicenseEntity entity = (LicenseEntity)((LicenseDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)1));
        LicenseVO vo = new LicenseVO();
        vo.setLicenseType(Integer.valueOf(1));
        vo.setComputerCode(MachineCodeUtil.getCpuId());
        if (null == entity) {
            vo.setCheckFlag(Integer.valueOf(-100));
            vo.setMessage("\u6388\u6743\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        } else {
            String unCrypStr = CustomizeEncryUtils.uncrypXML((String)entity.getLicenseSign());
            if (StringUtils.isBlank((CharSequence)unCrypStr)) {
                vo.setCheckFlag(Integer.valueOf(-1));
                vo.setMessage("\u6388\u6743\u7801\u89e3\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
            } else {
                DecryptLicenseDTO decryptLicenseDTO = (DecryptLicenseDTO)JSON.parseObject((String)unCrypStr, DecryptLicenseDTO.class);
                if (null == decryptLicenseDTO) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u6388\u6743\u7801\u53cd\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else if (!decryptLicenseDTO.getComputerCode().equalsIgnoreCase(vo.getComputerCode())) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u670d\u52a1\u5668\u673a\u5668\u7801\u4e0e\u6388\u6743\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else if (StringUtils.isBlank((CharSequence)decryptLicenseDTO.getSqDate())) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u6388\u6743\u7801\u65e5\u671f\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else {
                    Integer num = DateUtils.subtractionDay((String)decryptLicenseDTO.getSqDate(), (String)DateUtils.format((Date)new Date()));
                    if (num < 0) {
                        vo.setCheckFlag(Integer.valueOf(-2));
                        vo.setMessage("\u6388\u6743\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                    } else if (num >= 0 && num <= 60) {
                        vo.setCheckFlag(Integer.valueOf(1));
                        vo.setMessage("\u8ddd\u79bb\u6388\u6743\u8fc7\u671f\u8fd8\u5269" + num + "\u5929\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u5382\u5546\u5ef6\u957f\u6388\u6743\u7801\u65f6\u95f4");
                        vo.setSyDays(num);
                    } else {
                        vo.setCheckFlag(Integer.valueOf(0));
                    }
                }
            }
        }
        return vo;
    }

    public LicenseVO checkDeviceLicense() throws IOException {
        LicenseEntity entity = (LicenseEntity)((LicenseDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)2));
        LicenseVO vo = new LicenseVO();
        vo.setLicenseType(Integer.valueOf(2));
        vo.setComputerCode(MachineCodeUtil.getCpuId());
        if (null == entity) {
            vo.setCheckFlag(Integer.valueOf(-100));
            vo.setMessage("\u6388\u6743\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        } else {
            String unCrypStr = CustomizeEncryUtils.uncrypXML((String)entity.getLicenseSign());
            if (StringUtils.isBlank((CharSequence)unCrypStr)) {
                vo.setCheckFlag(Integer.valueOf(-1));
                vo.setMessage("\u6388\u6743\u7801\u89e3\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
            } else {
                DecryptLicenseDTO decryptLicenseDTO = (DecryptLicenseDTO)JSON.parseObject((String)unCrypStr, DecryptLicenseDTO.class);
                if (null == decryptLicenseDTO) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u6388\u6743\u7801\u53cd\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else if (!decryptLicenseDTO.getComputerCode().equalsIgnoreCase(vo.getComputerCode())) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u670d\u52a1\u5668\u673a\u5668\u7801\u4e0e\u6388\u6743\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else if (null == decryptLicenseDTO.getSqNum() || !NumberUtils.isNumeric((String)decryptLicenseDTO.getSqNum().toString())) {
                    vo.setCheckFlag(Integer.valueOf(-1));
                    vo.setMessage("\u6388\u6743\u6570\u91cf\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
                } else {
                    Integer count = this.sysExamDeviceConfService.selectCount();
                    if (decryptLicenseDTO.getSqNum() <= count) {
                        vo.setCheckFlag(Integer.valueOf(-1));
                        vo.setMessage("\u8bbe\u5907\u6388\u6743\u6570\u91cf\u8fbe\u5230\u6700\u5927\u503c\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u589e\u52a0\u6388\u6743\u6570\u91cf");
                    } else {
                        vo.setCheckFlag(Integer.valueOf(0));
                    }
                }
            }
        }
        return vo;
    }

    public LicenseVO saveDeviceLicense(LicenseDTO dto) {
        LicenseVO vo = new LicenseVO();
        String unCrypStr = CustomizeEncryUtils.uncrypXML((String)dto.getLicenseSign());
        if (StringUtils.isBlank((CharSequence)unCrypStr)) {
            throw new RenException("\u6388\u6743\u7801\u89e3\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        DecryptLicenseDTO decryptLicenseDTO = (DecryptLicenseDTO)JSON.parseObject((String)unCrypStr, DecryptLicenseDTO.class);
        if (null == decryptLicenseDTO) {
            throw new RenException("\u6388\u6743\u7801\u53cd\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (!decryptLicenseDTO.getComputerCode().equalsIgnoreCase(dto.getComputerCode())) {
            throw new RenException("\u670d\u52a1\u5668\u673a\u5668\u7801\u4e0e\u6388\u6743\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (null == decryptLicenseDTO.getSqNum() || !NumberUtils.isNumeric((String)decryptLicenseDTO.getSqNum().toString())) {
            vo.setCheckFlag(Integer.valueOf(-1));
            vo.setMessage("\u6388\u6743\u6570\u91cf\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        } else {
            ((LicenseDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)dto.getLicenseType()));
            this.insert(ConvertUtils.sourceToTarget((Object)dto, LicenseEntity.class));
            vo.setCheckFlag(Integer.valueOf(0));
            vo.setComputerCode(dto.getComputerCode());
            vo.setLicenseType(dto.getLicenseType());
            vo.setSqDate(decryptLicenseDTO.getSqDate());
            vo.setSqNum(decryptLicenseDTO.getSqNum());
        }
        return vo;
    }

    public String createLicense(DecryptLicenseDTO dto) {
        return CustomizeEncryUtils.encrypXML((String)JSON.toJSONString((Object)dto));
    }

    public void checkSysLicense() throws IOException {
        LicenseEntity entity = (LicenseEntity)((LicenseDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"license_type", (Object)1));
        if (null == entity) {
            throw new RenException("\u6388\u6743\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        String unCrypStr = CustomizeEncryUtils.uncrypXML((String)entity.getLicenseSign());
        if (StringUtils.isBlank((CharSequence)unCrypStr)) {
            throw new RenException("\u6388\u6743\u7801\u89e3\u7801\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        DecryptLicenseDTO decryptLicenseDTO = (DecryptLicenseDTO)JSON.parseObject((String)unCrypStr, DecryptLicenseDTO.class);
        if (null == decryptLicenseDTO) {
            throw new RenException("\u6388\u6743\u7801\u53cd\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (!decryptLicenseDTO.getComputerCode().equalsIgnoreCase(MachineCodeUtil.getCpuId())) {
            throw new RenException("\u670d\u52a1\u5668\u673a\u5668\u7801\u4e0e\u6388\u6743\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        if (StringUtils.isBlank((CharSequence)decryptLicenseDTO.getSqDate())) {
            throw new RenException("\u6388\u6743\u7801\u65e5\u671f\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
        Integer num = DateUtils.subtractionDay((String)decryptLicenseDTO.getSqDate(), (String)DateUtils.format((Date)new Date()));
        if (num < 0) {
            throw new RenException("\u6388\u6743\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u63d0\u4f9b\u6b63\u786e\u7684\u6388\u6743\u7801");
        }
    }
}

