/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.utils;

import io.huimu.common.constant.Constant;
import io.huimu.common.exception.RenException;
import io.huimu.modules.job.entity.ScheduleJobEntity;
import io.huimu.modules.job.utils.ScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScheduleUtils {
    private static final String JOB_NAME = "TASK_";
    public static final String JOB_PARAM_KEY = "JOB_PARAM_KEY";

    public static TriggerKey getTriggerKey(String jobId) {
        return TriggerKey.triggerKey((String)("TASK_" + jobId));
    }

    public static JobKey getJobKey(String jobId) {
        return JobKey.jobKey((String)("TASK_" + jobId));
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, String jobId) {
        try {
            return (CronTrigger)scheduler.getTrigger(ScheduleUtils.getTriggerKey((String)jobId));
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void createScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ScheduleJob.class).withIdentity(ScheduleUtils.getJobKey((String)scheduleJob.getId())).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(ScheduleUtils.getTriggerKey((String)scheduleJob.getId())).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            jobDetail.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob((Scheduler)scheduler, (String)scheduleJob.getId());
            }
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void updateScheduleJob(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            TriggerKey triggerKey = ScheduleUtils.getTriggerKey((String)scheduleJob.getId());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = ScheduleUtils.getCronTrigger((Scheduler)scheduler, (String)scheduleJob.getId());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            trigger.getJobDataMap().put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            if (scheduleJob.getStatus().intValue() == Constant.ScheduleStatus.PAUSE.getValue()) {
                ScheduleUtils.pauseJob((Scheduler)scheduler, (String)scheduleJob.getId());
            }
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void run(Scheduler scheduler, ScheduleJobEntity scheduleJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_PARAM_KEY", (Object)scheduleJob);
            scheduler.triggerJob(ScheduleUtils.getJobKey((String)scheduleJob.getId()), dataMap);
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void pauseJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.pauseJob(ScheduleUtils.getJobKey((String)jobId));
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void resumeJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.resumeJob(ScheduleUtils.getJobKey((String)jobId));
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, String jobId) {
        try {
            scheduler.deleteJob(ScheduleUtils.getJobKey((String)jobId));
        }
        catch (SchedulerException e) {
            throw new RenException(10028, (Throwable)e);
        }
    }
}

