/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictStandardDataSetDao;
import io.huimu.modules.dict.dto.DictStandardDataSetDTO;
import io.huimu.modules.dict.entity.DictStandardDataSetEntity;
import io.huimu.modules.dict.service.DictStandardDataSetService;
import io.huimu.modules.dict.vo.DatasetTypeVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictStandardDataSetServiceImpl
extends BaseServiceImpl<DictStandardDataSetDao, DictStandardDataSetEntity>
implements DictStandardDataSetService {
    public PageData<DatasetTypeVO> getDatasetTypePage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"datasetName"});
        PageHelper.startPage((int)Integer.parseInt((String)params.get("page")), (int)Integer.parseInt((String)params.get("limit")));
        List list = ((DictStandardDataSetDao)this.baseDao).getDatasetTypeList(params);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), DatasetTypeVO.class);
    }

    public PageData<DictStandardDataSetDTO> page(Map<String, Object> params) {
        IPage page = ((DictStandardDataSetDao)this.baseDao).selectPage(this.getPage(params, "", false), (Wrapper)this.getWrapper(params));
        return this.getPageData(page, DictStandardDataSetDTO.class);
    }

    private QueryWrapper<DictStandardDataSetEntity> getWrapper(Map<String, Object> params) {
        String nbBsf = (String)params.get("nbBsf");
        String dataBsf = (String)params.get("dataBsf");
        String dataName = (String)params.get("dataName");
        String define = (String)params.get("DEFINE");
        Integer datasetType = (Integer)params.get("datasetType");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByAsc((Object)"NB_BSF");
        wrapper.eq((Object)"DATASET_TYPE", (Object)datasetType);
        wrapper.like(StringUtils.isNotBlank((CharSequence)nbBsf), (Object)"NB_BSF", (Object)nbBsf);
        wrapper.like(StringUtils.isNotBlank((CharSequence)dataBsf), (Object)"DATA_BSF", (Object)dataBsf);
        wrapper.like(StringUtils.isNotBlank((CharSequence)dataName), (Object)"DATA_NAME", (Object)dataName);
        wrapper.like(StringUtils.isNotBlank((CharSequence)define), (Object)"DEFINE", (Object)define);
        return wrapper;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveByExcel(List<DictStandardDataSetDTO> list) {
        if (CollUtil.isNotEmpty(list)) {
            DictStandardDataSetDTO dto = list.get(0);
            ((DictStandardDataSetDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"DATASET_TYPE", (Object)dto.getDatasetType()));
            this.insertBatch((Collection)ConvertUtils.sourceToTarget(list, DictStandardDataSetEntity.class), 100);
        }
    }
}

