/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.exception;

import cn.hutool.core.map.MapUtil;
import io.huimu.common.exception.ExceptionUtils;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.HttpContextUtils;
import io.huimu.common.utils.IpUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.log.entity.SysLogExceptionEntity;
import io.huimu.modules.log.service.SysLogExceptionService;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RenExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RenExceptionHandler.class);
    @Autowired
    private SysLogExceptionService exceptionService;

    @ExceptionHandler(value={RenException.class})
    public Result handleRenException(RenException ex) {
        Result result = new Result();
        result.error(ex.getCode(), ex.getMsg());
        this.saveLog((Exception)ex);
        return result;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result handleDuplicateKeyException(DuplicateKeyException ex) {
        Result result = new Result();
        result.error(10002);
        this.saveLog((Exception)ex);
        return result;
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public Result handleUnauthorizedException(UnauthorizedException ex) {
        Result result = new Result();
        result.error(403);
        this.saveLog((Exception)ex);
        return result;
    }

    @ExceptionHandler(value={Exception.class})
    public Result handleException(Exception ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        this.saveLog(ex);
        return new Result().error();
    }

    private void saveLog(Exception ex) {
        SysLogExceptionEntity log = new SysLogExceptionEntity();
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestUri(request.getRequestURI());
        log.setRequestMethod(request.getMethod());
        log.setCreateName(SecurityUser.getUser().getRealName());
        Map params = HttpContextUtils.getParameterMap((HttpServletRequest)request);
        if (MapUtil.isNotEmpty((Map)params)) {
            log.setRequestParams(JsonUtils.toJsonString((Object)params));
        }
        log.setErrorMsg(ExceptionUtils.getErrorStackTrace((Exception)ex));
        this.exceptionService.insert((Object)log);
    }
}

