/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.ExceptionUtils;
import io.huimu.common.utils.HttpContextUtils;
import io.huimu.common.utils.IpUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.modules.log.entity.SysLogErrorEntity;
import io.huimu.modules.log.entity.SysLogSuccessEntity;
import io.huimu.modules.log.service.SysLogErrorService;
import io.huimu.modules.log.service.SysLogSuccessService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.security.user.UserDetail;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class LogOperationAspect {
    @Autowired
    private SysLogSuccessService successService;
    @Autowired
    private SysLogErrorService errorService;

    @Pointcut(value="@annotation(io.huimu.common.annotation.LogOperation)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        try {
            Object result = point.proceed();
            long time = System.currentTimeMillis() - beginTime;
            this.saveSuccessLog(point, time, result);
            return result;
        }
        catch (Exception e) {
            long time = System.currentTimeMillis() - beginTime;
            this.saveErrorLog(point, time, ExceptionUtils.getErrorStackTrace((Exception)e));
            throw e;
        }
    }

    private void saveSuccessLog(ProceedingJoinPoint joinPoint, long time, Object result) throws Exception {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), signature.getParameterTypes());
        LogOperation annotation = method.getAnnotation(LogOperation.class);
        SysLogSuccessEntity log = new SysLogSuccessEntity();
        if (annotation != null) {
            log.setOperation(annotation.value());
            log.setModule(annotation.module());
            log.setOperationType(annotation.operationType());
            log.setLogType(Integer.valueOf(annotation.logType()));
        }
        log.setResponseParam(JsonUtils.toJsonString((Object)result));
        UserDetail user = SecurityUser.getUser();
        if (user != null) {
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
        }
        log.setRequestTime(Integer.valueOf((int)time));
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestUri(request.getRequestURI());
        log.setRequestMethod(request.getMethod());
        Object[] args = joinPoint.getArgs();
        try {
            Object data;
            JSONObject object;
            String params = JsonUtils.toJsonString((Object)args[0]);
            log.setRequestParams(params);
            if (StringUtils.isNotBlank((CharSequence)params) && null != (object = JSON.parseObject((String)params)) && null != (data = object.get((Object)"data"))) {
                JSONObject jsonObject = JSON.parseObject((String)JsonUtils.toJsonString((Object)data));
                log.setPatientId((String)jsonObject.get((Object)"patientId"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.successService.insert((Object)log);
    }

    private void saveErrorLog(ProceedingJoinPoint joinPoint, long time, String errorMsg) throws Exception {
        UserDetail user;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), signature.getParameterTypes());
        LogOperation annotation = method.getAnnotation(LogOperation.class);
        SysLogErrorEntity log = new SysLogErrorEntity();
        if (annotation != null) {
            log.setOperation(annotation.value());
            log.setModule(annotation.module());
            log.setOperationType(annotation.operationType());
            log.setLogType(Integer.valueOf(annotation.logType()));
        }
        if ((user = SecurityUser.getUser()) != null) {
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
        }
        log.setErrorMsg(errorMsg);
        log.setRequestTime(Integer.valueOf((int)time));
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestUri(request.getRequestURI());
        log.setRequestMethod(request.getMethod());
        Object[] args = joinPoint.getArgs();
        try {
            Object data;
            JSONObject object;
            String params = JsonUtils.toJsonString((Object)args[0]);
            log.setRequestParams(params);
            if (StringUtils.isNotBlank((CharSequence)params) && null != (object = JSON.parseObject((String)params)) && null != (data = object.get((Object)"data"))) {
                JSONObject jsonObject = JSON.parseObject((String)JsonUtils.toJsonString((Object)data));
                log.setPatientId((String)jsonObject.get((Object)"patientId"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.errorService.insert((Object)log);
    }
}

