/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.visit.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.visit.dto.add.AddVisitDTO;
import io.huimu.modules.visit.dto.update.UpdateVisitDTO;
import io.huimu.modules.visit.param.GetVisitListParam;
import io.huimu.modules.visit.param.GetVisitPageParam;
import io.huimu.modules.visit.service.VisitService;
import io.huimu.modules.visit.vo.VisitInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"visit"})
@Api(tags={"\u968f\u8bbf\u8bbe\u7f6e"})
public class VisitController {
    @Autowired
    private VisitService visitService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u65b9\u6848-\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetVisitPageParam.class)
    public Result<PageData<VisitInfoVO>> page(@RequestBody EncryptedReq<GetVisitPageParam> req) throws IllegalAccessException {
        GetVisitPageParam param = (GetVisitPageParam)req.getData();
        return new Result().ok(req.getEncode(), (Object)this.visitService.page(MapUtils.object2Map((Object)param)));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u65b9\u6848\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetVisitListParam.class)
    public Result<List<VisitInfoVO>> getList(@RequestBody EncryptedReq<GetVisitListParam> req) {
        GetVisitListParam param = (GetVisitListParam)req.getData();
        return new Result().ok(req.getEncode(), (Object)this.visitService.getList(param.getOrgCode()));
    }

    @PostMapping(value={"saveVisit"})
    @ApiOperation(value="\u65b0\u589e\u968f\u8bbf")
    @LogOperation(value="\u65b0\u589e\u968f\u8bbf\u65b9\u6848", module="\u968f\u8bbf\u8bbe\u7f6e", operationType=1)
    @DecryptAndVerify(decryptedClass=AddVisitDTO.class)
    public Result save(@RequestBody EncryptedReq<AddVisitDTO> req) {
        AddVisitDTO dto = (AddVisitDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.visitService.save(dto);
    }

    @PostMapping(value={"updateVisit"})
    @ApiOperation(value="\u4fee\u6539\u968f\u8bbf")
    @LogOperation(value="\u4fee\u6539\u968f\u8bbf\u65b9\u6848", module="\u968f\u8bbf\u8bbe\u7f6e", operationType=2)
    @DecryptAndVerify(decryptedClass=UpdateVisitDTO.class)
    public Result update(@RequestBody EncryptedReq<UpdateVisitDTO> req) {
        UpdateVisitDTO dto = (UpdateVisitDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.visitService.update(dto);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u65b9\u6848-\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<VisitInfoVO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"id"});
        return new Result().ok(req.getEncode(), (Object)this.visitService.getInfo(param.getId()));
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u65b9\u6848-\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u968f\u8bbf\u65b9\u6848", module="\u968f\u8bbf\u8bbe\u7f6e", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"id"});
        this.visitService.delete(param.getId());
        return new Result();
    }
}

