/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.page.PageData;
import io.huimu.common.param.UserPageParam;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.common.utils.Result;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dao.SysRoleUserDao;
import io.huimu.modules.sys.dao.SysUserDao;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.huimu.modules.sys.entity.SysUserEntity;
import io.huimu.modules.sys.enums.SuperAdminEnum;
import io.huimu.modules.sys.enums.UserStatusEnum;
import io.huimu.modules.sys.service.SysRoleUserService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import io.huimu.modules.sys.service.SysUserService;
import io.huimu.modules.sys.vo.DoctorVO;
import io.huimu.modules.sys.vo.SysUserVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserServiceImpl
extends BaseServiceImpl<SysUserDao, SysUserEntity>
implements SysUserService {
    @Autowired
    private SysRoleUserService sysRoleUserService;
    @Autowired
    private SysUserDeptDataScopeService deptDataScopeService;
    @Autowired
    private SysRoleUserDao roleUserDao;

    public PageData<SysUserVO> page(UserPageParam param) {
        PageHelper.startPage((int)Integer.parseInt(param.getPage()), (int)Integer.parseInt(param.getLimit()));
        List list = ((SysUserDao)this.baseDao).getUserList(param);
        for (SysUserVO vo : list) {
            vo.setDefaultRole(this.roleUserDao.getDefaultRoleName(vo.getId(), param.getOrgCode()));
            List scopeNameList = this.deptDataScopeService.getDeptDataScopeName(param.getOrgCode(), vo.getId());
            if (!CollectionUtils.isNotEmpty((Collection)scopeNameList)) continue;
            vo.setDataScope(String.join((CharSequence)"\u3001", scopeNameList));
        }
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), SysUserVO.class);
    }

    public List<SysUserVO> list(UserPageParam params) {
        List entityList = ((SysUserDao)this.baseDao).getUserList(params);
        return ConvertUtils.sourceToTarget((Collection)entityList, SysUserVO.class);
    }

    public SysUserDTO getByEmployeeId(String employeeId) {
        return ((SysUserDao)this.baseDao).getByEmployeeId(employeeId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveUser(SysUserDTO dto) {
        SysUserEntity entity = (SysUserEntity)ConvertUtils.sourceToTarget((Object)dto, SysUserEntity.class);
        String password = HutoolSm4Utils.encode((String)entity.getPassword());
        entity.setPassword(password);
        entity.setSuperAdmin(Integer.valueOf(SuperAdminEnum.NO.value()));
        entity.setPwdErrorNum(Integer.valueOf(0));
        this.insert((Object)entity);
        this.sysRoleUserService.saveOrUpdate(entity.getId(), dto.getRoleIdList(), dto.getDefaultRoleId());
        this.deptDataScopeService.saveOrUpdate(entity.getId(), dto.getDataScopeList());
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateUser(SysUserDTO dto) {
        int count = ((SysUserDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)dto.getEmployeeId())).ne((Object)"ID", (Object)dto.getId()));
        if (count > 0) {
            return new Result().error("\u5de5\u53f7\u5df2\u5b58\u5728");
        }
        SysUserEntity entity = (SysUserEntity)ConvertUtils.sourceToTarget((Object)dto, SysUserEntity.class);
        if (StringUtils.isBlank((CharSequence)dto.getPassword())) {
            entity.setPassword(null);
        } else {
            String password = HutoolSm4Utils.encode((String)entity.getPassword());
            entity.setPassword(password);
        }
        if (entity.getStatus().intValue() == UserStatusEnum.ENABLED.value()) {
            entity.setPwdErrorNum(Integer.valueOf(0));
        }
        this.updateById((Object)entity);
        this.sysRoleUserService.saveOrUpdate(entity.getId(), dto.getRoleIdList(), dto.getDefaultRoleId());
        this.deptDataScopeService.saveOrUpdate(entity.getId(), dto.getDataScopeList());
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String[] ids) {
        ((SysUserDao)this.baseDao).deleteBatchIds(Arrays.asList(ids));
        this.sysRoleUserService.deleteByUserIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePassword(String employeeId, String newPassword) {
        newPassword = HutoolSm4Utils.encode((String)newPassword);
        ((SysUserDao)this.baseDao).updatePassword(employeeId, newPassword);
    }

    public void updatePwdErrorNumAndLockStatus(String id, Integer pwdErrorNum, Integer lockStatus) {
        SysUserEntity entity = new SysUserEntity();
        entity.setId(id);
        entity.setPwdErrorNum(pwdErrorNum);
        entity.setStatus(lockStatus);
        this.updateById((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Result importUser(List<SysUserDTO> list) {
        Set filteredSet = list.stream().collect(Collectors.toCollection(() -> new TreeSet<SysUserDTO>(Comparator.comparing(SysUserDTO::getEmployeeId))));
        if (filteredSet.size() != list.size()) {
            return new Result().error("\u5217\u8868\u4e2d\u5305\u542b\u76f8\u540c\u5de5\u53f7\u7684\u7528\u6237");
        }
        for (SysUserDTO dto : list) {
            if (!StringUtils.isNotBlank((CharSequence)dto.getEmployeeId())) continue;
            SysUserDTO dbEntity = ((SysUserDao)this.baseDao).getByEmployeeId(dto.getEmployeeId());
            if (null != dbEntity) {
                dbEntity.setRealName(dbEntity.getRealName());
                dbEntity.setEmail(dto.getEmail());
                dbEntity.setMobile(dto.getMobile());
                dbEntity.setGender(dto.getGender());
                this.updateById(ConvertUtils.sourceToTarget((Object)dbEntity, SysUserEntity.class));
                continue;
            }
            SysUserEntity entity = (SysUserEntity)ConvertUtils.sourceToTarget((Object)dto, SysUserEntity.class);
            entity.setPassword(HutoolSm4Utils.encode((String)entity.getEmployeeId()));
            entity.setStatus(Integer.valueOf(UserStatusEnum.ENABLED.value()));
            entity.setPwdErrorNum(Integer.valueOf(0));
            entity.setSuperAdmin(Integer.valueOf(SuperAdminEnum.NO.value()));
            entity.setCreator(SecurityUser.getUserId());
            this.insert((Object)entity);
        }
        return new Result();
    }

    public List<SysUserVO> getList(Map<String, Object> params) {
        return ((SysUserDao)this.baseDao).getList(params);
    }

    public List<DoctorVO> getDoctorList(Integer type, String orgCode) {
        return ((SysUserDao)this.baseDao).getDoctorList(type, orgCode);
    }

    public SysUserDTO getInfo(String id) {
        return ((SysUserDao)this.baseDao).getById(id);
    }

    public String test() {
        return ((SysUserDao)this.baseDao).test();
    }

    public List<String> getUserNameList(List<String> employeeIds) {
        return ((SysUserDao)this.baseDao).getUserNameList(employeeIds);
    }
}

