/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.modules.sys.dao.SysRoleDao;
import io.huimu.modules.sys.dto.SysRoleDTO;
import io.huimu.modules.sys.entity.SysDeptEntity;
import io.huimu.modules.sys.entity.SysRoleEntity;
import io.huimu.modules.sys.param.SetDefaultRoleParam;
import io.huimu.modules.sys.param.SysRolePageParam;
import io.huimu.modules.sys.param.SysRoleSearchParam;
import io.huimu.modules.sys.service.SysDeptService;
import io.huimu.modules.sys.service.SysRoleMenuService;
import io.huimu.modules.sys.service.SysRoleService;
import io.huimu.modules.sys.service.SysRoleUserService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleServiceImpl
extends BaseServiceImpl<SysRoleDao, SysRoleEntity>
implements SysRoleService {
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysRoleUserService sysRoleUserService;
    @Autowired
    private SysDeptService sysDeptService;

    public PageData<SysRoleDTO> page(SysRolePageParam param) throws IllegalAccessException {
        SysDeptEntity entity;
        PageHelper.startPage((int)Integer.parseInt(param.getPage()), (int)Integer.parseInt(param.getLimit()));
        Map params = MapUtils.object2Map((Object)param);
        if (StringUtils.isNotBlank((CharSequence)param.getOrgCode()) && StringUtils.isNotBlank((CharSequence)param.getDeptCode()) && null != (entity = this.sysDeptService.getInfoByOrgAndDeptCode(param.getOrgCode(), param.getDeptCode()))) {
            List deptIdList = this.sysDeptService.getSubDeptIdList(entity.getId());
            params.put("deptIdList", deptIdList);
        }
        List list = ((SysRoleDao)this.baseDao).getRoleList(params);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), SysRoleDTO.class);
    }

    public List<SysRoleDTO> getList(SysRoleSearchParam params) throws IllegalAccessException {
        List entityList = ((SysRoleDao)this.baseDao).getRoleList(MapUtils.object2Map((Object)params));
        return ConvertUtils.sourceToTarget((Collection)entityList, SysRoleDTO.class);
    }

    public SysRoleDTO getInfo(String id) {
        SysRoleDTO data = ((SysRoleDao)this.baseDao).getRoleInfoById(id);
        List menuIdList = this.sysRoleMenuService.getMenuIdList(id);
        data.setMenuIdList(menuIdList);
        return data;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveRole(SysRoleDTO dto) {
        SysRoleEntity entity = (SysRoleEntity)ConvertUtils.sourceToTarget((Object)dto, SysRoleEntity.class);
        this.insert((Object)entity);
        this.sysRoleMenuService.saveOrUpdate(entity.getId(), dto.getMenuIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRole(SysRoleDTO dto) {
        SysRoleEntity entity = (SysRoleEntity)ConvertUtils.sourceToTarget((Object)dto, SysRoleEntity.class);
        this.updateById((Object)entity);
        this.sysRoleMenuService.saveOrUpdate(entity.getId(), dto.getMenuIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String[] ids) {
        ((SysRoleDao)this.baseDao).deleteBatchIds(Arrays.asList(ids));
        this.sysRoleUserService.deleteByRoleIds(ids);
        this.sysRoleMenuService.deleteByRoleIds(ids);
    }

    public SysRoleDTO getRoleInfoById(String roleId) {
        return ((SysRoleDao)this.baseDao).getRoleInfoById(roleId);
    }

    public void setDefaultRole(SetDefaultRoleParam dto) {
        this.sysRoleUserService.saveOrUpdateDefaultRole(dto.getUserId(), dto.getRoleId());
    }

    public Integer getCountByDeptCode(String deptCode, String orgCode) {
        return ((SysRoleDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEPT_CODE", (Object)deptCode)).eq((Object)"ORG_CODE", (Object)orgCode));
    }
}

