/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.rissubclassbz.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.IdsParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.rissubclassbz.dto.RisSubclassBzDTO;
import io.huimu.modules.rissubclassbz.param.GetListParam;
import io.huimu.modules.rissubclassbz.param.GetRisSubclassBzParam;
import io.huimu.modules.rissubclassbz.service.RisSubclassBzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ris/subclass/bz"})
@Api(tags={"\u68c0\u67e5\u90e8\u4f4d\u5907\u6ce8"})
public class RisSubclassBzController {
    @Autowired
    private RisSubclassBzService risSubclassBzService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetRisSubclassBzParam.class)
    public Result<PageData<RisSubclassBzDTO>> page(@RequestBody EncryptedReq<GetRisSubclassBzParam> req) throws IllegalAccessException {
        GetRisSubclassBzParam params = (GetRisSubclassBzParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.risSubclassBzService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<RisSubclassBzDTO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam params = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        RisSubclassBzDTO dto = this.risSubclassBzService.getInfo(params.getId());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e\u90e8\u4f4d\u5907\u6ce8")
    @LogOperation(value="\u65b0\u589e\u90e8\u4f4d\u5907\u6ce8", module="\u68c0\u67e5\u90e8\u4f4d\u5907\u6ce8", operationType=1)
    @DecryptAndVerify(decryptedClass=RisSubclassBzDTO.class)
    public Result save(@RequestBody EncryptedReq<RisSubclassBzDTO> req) {
        RisSubclassBzDTO dto = (RisSubclassBzDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.risSubclassBzService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u90e8\u4f4d\u5907\u6ce8")
    @LogOperation(value="\u4fee\u6539\u90e8\u4f4d\u5907\u6ce8", module="\u68c0\u67e5\u90e8\u4f4d\u5907\u6ce8", operationType=2)
    @DecryptAndVerify(decryptedClass=RisSubclassBzDTO.class)
    public Result updateTag(@RequestBody EncryptedReq<RisSubclassBzDTO> req) {
        RisSubclassBzDTO dto = (RisSubclassBzDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class, UpdateGroup.class});
        this.risSubclassBzService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getListByExamTypeCode"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u7c7b\u578bcode\uff0c\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetListParam.class)
    public Result<List<RisSubclassBzDTO>> tree(@RequestBody EncryptedReq<GetListParam> req) {
        GetListParam param = (GetListParam)req.getData();
        List list = this.risSubclassBzService.getListByExamTypeCode(param);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u90e8\u4f4d\u5907\u6ce8")
    @LogOperation(value="\u5220\u9664\u90e8\u4f4d\u5907\u6ce8", module="\u68c0\u67e5\u90e8\u4f4d\u5907\u6ce8", operationType=3)
    @DecryptAndVerify(decryptedClass=IdsParam.class)
    public Result delete(@RequestBody EncryptedReq<IdsParam> req) {
        IdsParam idParam = (IdsParam)req.getData();
        ValidatorUtils.validateEntity((Object)idParam, (Class[])new Class[0]);
        this.risSubclassBzService.deleteBatchIds((Collection)idParam.getId());
        return new Result();
    }
}

