/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.status.ExamStatus;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.hisregister.dto.HisRegisterDTO;
import io.huimu.modules.hisregister.entity.HisRegisterEntity;
import io.huimu.modules.hisregister.service.HisRegisterService;
import io.huimu.modules.register.dao.RegisterExamDao;
import io.huimu.modules.register.dto.RegisterExamDTO;
import io.huimu.modules.register.dto.UpdateRegisterExamDTO;
import io.huimu.modules.register.entity.RegisterExamEntity;
import io.huimu.modules.register.entity.RegisterPatientEntity;
import io.huimu.modules.register.param.DelRegisterParam;
import io.huimu.modules.register.param.GetPatientParam;
import io.huimu.modules.register.param.ManualRegisterParam;
import io.huimu.modules.register.param.QueryManualRegister;
import io.huimu.modules.register.service.RegisterExamService;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.register.service.RegisterPatientService;
import io.huimu.modules.register.vo.RegisterExamInfoVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RegisterExamServiceImpl
extends BaseServiceImpl<RegisterExamDao, RegisterExamEntity>
implements RegisterExamService {
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private RegisterPatientService registerPatientService;
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private SysUserDeptDataScopeService dataScopeService;
    @Autowired
    private HisRegisterService hisRegisterService;

    public PageData<RegisterExamInfoVO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientIdNumber", "patientName", "sqysName"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        String page = (String)params.get("page");
        String limit = (String)params.get("limit");
        PageHelper.startPage((int)Integer.parseInt(page), (int)Integer.parseInt(limit));
        List list = ((RegisterExamDao)this.baseDao).getExamList(params);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), RegisterExamInfoVO.class);
    }

    public List<RegisterExamInfoVO> getList(Map<String, Object> params) {
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        return ((RegisterExamDao)this.baseDao).getExamList(params);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateExam(UpdateRegisterExamDTO dto) {
        RegisterExamEntity entity = (RegisterExamEntity)ConvertUtils.sourceToTarget((Object)dto, RegisterExamEntity.class);
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"RIS_NO", (Object)entity.getRisNo()));
        RegisterPatientEntity patientEntity = (RegisterPatientEntity)ConvertUtils.sourceToTarget((Object)dto, RegisterPatientEntity.class);
        this.registerPatientService.update((Object)patientEntity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)dto.getPatientId())).eq((Object)"HOSPITAL_ORG_CODE", (Object)dto.getHospitalOrgCode()));
    }

    @Transactional(rollbackFor={Exception.class})
    public Result addExam(RegisterExamDTO dto) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orgCode", dto.getHospitalOrgCode());
        param.put("patientId", dto.getPatientId());
        HisRegisterDTO hisRegisterDTO = this.hisRegisterService.getPatientInfo(param);
        if (null != hisRegisterDTO) {
            if (StringUtils.isBlank((CharSequence)dto.getJzNumber())) {
                dto.setJzNumber(hisRegisterDTO.getJzNumber());
            }
        } else if (StringUtils.isBlank((CharSequence)dto.getJzNumber())) {
            dto.setJzNumber(this.hisRegisterService.selectJzNumber());
        }
        HisRegisterEntity hisRegisterEntity = new HisRegisterEntity();
        hisRegisterEntity.setJzNumber(dto.getJzNumber());
        hisRegisterEntity.setGhKsCode(dto.getReqDeptCode());
        hisRegisterEntity.setGhKsName(dto.getReqDept());
        hisRegisterEntity.setGhDoctorCode(SecurityUser.getEmployeeId());
        hisRegisterEntity.setGhDoctorName(SecurityUser.getUser().getRealName());
        hisRegisterEntity.setHisTime(new Date());
        hisRegisterEntity.setHospitalCode(dto.getHospitalOrgCode());
        hisRegisterEntity.setPatientAddress(dto.getPatientAddress());
        hisRegisterEntity.setPatientBirthday(dto.getPatientBirthday());
        hisRegisterEntity.setPatientId(dto.getPatientId());
        hisRegisterEntity.setPatientIdNumber(dto.getPatientIdNumber());
        hisRegisterEntity.setPatientName(dto.getPatientName());
        hisRegisterEntity.setPatientPhone(dto.getPatientPhone());
        hisRegisterEntity.setPatientSex(dto.getPatientSex());
        hisRegisterEntity.setPatientSource(dto.getPatientSource());
        hisRegisterEntity.setMzNumber(dto.getMzNumber());
        hisRegisterEntity.setHisFlag(Integer.valueOf(0));
        hisRegisterEntity.setZyNumber(dto.getZyNumber());
        this.hisRegisterService.saveHisRecord(hisRegisterEntity);
        RegisterExamEntity entity = (RegisterExamEntity)ConvertUtils.sourceToTarget((Object)dto, RegisterExamEntity.class);
        String risNoSeq = ((RegisterExamDao)this.baseDao).getRisNoSeq();
        String risNo = "OEIS" + DateUtils.format((Date)new Date(), (String)"yyMMdd") + risNoSeq;
        entity.setRisNo(risNo);
        entity.setRegisterType(Integer.valueOf(1));
        entity.setReqPhysicianCode(SecurityUser.getUser().getEmployeeId());
        entity.setReqPhysician(SecurityUser.getUser().getRealName());
        entity.setReqDept(dto.getReqDept());
        entity.setPatientInputId(dto.getZyNumber());
        entity.setPatientOutputId(dto.getMzNumber());
        this.insert((Object)entity);
        this.registerItemService.save(dto.getPatientId(), risNo, dto.getReqDeptCode(), dto.getHospitalOrgCode(), dto.getPrjList());
        return new Result().ok((Object)dto.getPatientId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteExam(DelRegisterParam dto) {
        Integer count = this.registerItemService.getExecuteItem(dto.getRisNo(), ExamStatus.EXAM_FINISH);
        if (count > 0) {
            throw new RenException(this.sysSystemConfService.getConfValue("100020", "\u5b58\u5728\u5df2\u6267\u884c\u7684\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c"));
        }
        this.registerItemService.deleteByRisNo(dto);
    }

    public RegisterExamInfoVO getExamInfo(String risNo) {
        RegisterExamInfoVO vo = ((RegisterExamDao)this.baseDao).getExamInfo(risNo);
        if (null != vo) {
            vo.setItemList(this.registerItemService.getExamItemList(risNo));
        }
        return vo;
    }

    public RegisterExamInfoVO getPatientInfo(GetPatientParam dto) throws IllegalAccessException, IOException {
        HisRegisterDTO hisRegisterDTO = this.hisRegisterService.getPatientInfo(MapUtils.object2Map((Object)dto));
        if (null != hisRegisterDTO) {
            return (RegisterExamInfoVO)ConvertUtils.sourceToTarget((Object)hisRegisterDTO, RegisterExamInfoVO.class);
        }
        return null;
    }

    public List<RegisterExamInfoVO> getExcelList(Map<String, Object> params) {
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        return ((RegisterExamDao)this.baseDao).getExamList(params);
    }

    public Object queryManualRegister(QueryManualRegister dto) throws IllegalAccessException {
        String queryManualRegisterUrl = this.sysSystemConfService.getConfValue("100050", "");
        if (StringUtils.isNotBlank((CharSequence)queryManualRegisterUrl)) {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)dto), (MultiValueMap)headers);
            ResponseEntity responseResult = null;
            try {
                System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u83b7\u53d6his\u60a3\u8005\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)httpEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue}));
                responseResult = restTemplate.exchange(queryManualRegisterUrl, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            }
            catch (Exception e) {
                throw new RenException(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".....\u83b7\u53d6his\u60a3\u8005\u8c03\u7528\u5931\u8d25\uff1a\u4fe1\u606f\uff1a" + e.getMessage());
            }
            if (null != responseResult) {
                JSONObject jsonObject = (JSONObject)responseResult.getBody();
                if (null != jsonObject) {
                    int code = (Integer)jsonObject.get((Object)"code");
                    if (code == 0) {
                        return jsonObject.get((Object)"data");
                    }
                    throw new RenException((String)jsonObject.get((Object)"msg"));
                }
                throw new RenException("\u67e5\u8be2\u624b\u5de5\u767b\u8bb0\u8fd4\u56de\u4e3a\u7a7a");
            }
            throw new RenException("\u67e5\u8be2\u624b\u5de5\u767b\u8bb0\u8fd4\u56de\u4e3a\u7a7a");
        }
        return null;
    }

    public Result manualRegister(ManualRegisterParam dto) {
        String queryManualRegisterUrl = this.sysSystemConfService.getConfValue("100051", "");
        if (StringUtils.isNotBlank((CharSequence)queryManualRegisterUrl)) {
            dto.setRegisterUserId(SecurityUser.getEmployeeId());
            dto.setRegisterUserName(SecurityUser.getUser().getRealName());
            dto.setRegisterSource("\u4eba\u5de5");
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            ResponseEntity responseResult = null;
            try {
                System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u4eba\u5de5\u767b\u8bb0\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)httpEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue}));
                responseResult = restTemplate.exchange(queryManualRegisterUrl, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            }
            catch (Exception e) {
                throw new RenException(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".....\u4eba\u5de5\u767b\u8bb0\u8c03\u7528\u5931\u8d25\uff1a\u4fe1\u606f\uff1a" + e.getMessage());
            }
            if (null != responseResult) {
                JSONObject jsonObject = (JSONObject)responseResult.getBody();
                if (null != jsonObject) {
                    int code = (Integer)jsonObject.get((Object)"code");
                    if (code == 0) {
                        return new Result();
                    }
                    throw new RenException((String)jsonObject.get((Object)"msg"));
                }
                throw new RenException("\u4eba\u5de5\u767b\u8bb0\u8fd4\u56de\u4e3a\u7a7a");
            }
            throw new RenException("\u4eba\u5de5\u767b\u8bb0\u8fd4\u56de\u4e3a\u7a7a");
        }
        return new Result().error("\u4eba\u5de5\u767b\u8bb0\u63a5\u53e3\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

